/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.appenderator;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.druid.indexing.common.actions.SegmentListUsedAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.segment.realtime.appenderator.UsedSegmentChecker;
import org.apache.druid.timeline.DataSegment;

public class ActionBasedUsedSegmentChecker
implements UsedSegmentChecker {
    private final TaskActionClient taskActionClient;

    public ActionBasedUsedSegmentChecker(TaskActionClient taskActionClient) {
        this.taskActionClient = taskActionClient;
    }

    public Set<DataSegment> findUsedSegments(Set<SegmentIdWithShardSpec> identifiers) throws IOException {
        TreeMap identifiersByDataSource = new TreeMap();
        for (SegmentIdWithShardSpec identifier : identifiers) {
            if (!identifiersByDataSource.containsKey(identifier.getDataSource())) {
                identifiersByDataSource.put(identifier.getDataSource(), new HashSet());
            }
            ((Set)identifiersByDataSource.get(identifier.getDataSource())).add(identifier);
        }
        HashSet<DataSegment> retVal = new HashSet<DataSegment>();
        for (Map.Entry entry : identifiersByDataSource.entrySet()) {
            ArrayList intervals = JodaUtils.condenseIntervals((Iterable)Iterables.transform((Iterable)((Iterable)entry.getValue()), input -> input.getInterval()));
            List<DataSegment> usedSegmentsForIntervals = this.taskActionClient.submit(new SegmentListUsedAction((String)entry.getKey(), null, intervals));
            for (DataSegment segment : usedSegmentsForIntervals) {
                if (!identifiers.contains(SegmentIdWithShardSpec.fromDataSegment((DataSegment)segment))) continue;
                retVal.add(segment);
            }
        }
        return retVal;
    }
}

