/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.updater;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.server.DruidNode;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class HadoopDruidConverterConfig {
    public static final String CONFIG_PROPERTY = "org.apache.druid.indexer.updater.converter";
    public static final ObjectMapper jsonMapper;
    public static final IndexIO INDEX_IO;
    public static final IndexMerger INDEX_MERGER;
    public static final DataSegmentPusher DATA_SEGMENT_PUSHER;
    private static final Injector injector;
    @JsonProperty
    private final String dataSource;
    @JsonProperty
    private final Interval interval;
    @JsonProperty
    private final IndexSpec indexSpec;
    @JsonProperty
    private final List<DataSegment> segments;
    @JsonProperty
    private final boolean validate;
    @JsonProperty
    private final URI distributedSuccessCache;
    @JsonProperty
    private final Map<String, String> hadoopProperties;
    @JsonProperty
    private final String jobPriority;
    @JsonProperty
    private final String segmentOutputPath;

    public static HadoopDruidConverterConfig fromString(String string) throws IOException {
        return HadoopDruidConverterConfig.fromMap((Map)jsonMapper.readValue(string, JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT));
    }

    public static HadoopDruidConverterConfig fromMap(Map<String, Object> map) {
        return (HadoopDruidConverterConfig)jsonMapper.convertValue(map, HadoopDruidConverterConfig.class);
    }

    @JsonCreator
    public HadoopDruidConverterConfig(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="segments") List<DataSegment> segments, @JsonProperty(value="validate") Boolean validate, @JsonProperty(value="distributedSuccessCache") URI distributedSuccessCache, @JsonProperty(value="hadoopProperties") Map<String, String> hadoopProperties, @JsonProperty(value="jobPriority") String jobPriority, @JsonProperty(value="segmentOutputPath") String segmentOutputPath) {
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.interval = (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval");
        this.indexSpec = (IndexSpec)Preconditions.checkNotNull((Object)indexSpec, (Object)"indexSpec");
        this.distributedSuccessCache = (URI)Preconditions.checkNotNull((Object)distributedSuccessCache, (Object)"distributedSuccessCache");
        this.segments = segments;
        this.validate = validate == null ? false : validate;
        this.hadoopProperties = hadoopProperties == null ? ImmutableMap.of() : ImmutableMap.copyOf(hadoopProperties);
        this.jobPriority = jobPriority;
        this.segmentOutputPath = (String)Preconditions.checkNotNull((Object)segmentOutputPath, (Object)"segmentOutputPath");
    }

    @JsonProperty
    public boolean isValidate() {
        return this.validate;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty
    public IndexSpec getIndexSpec() {
        return this.indexSpec;
    }

    @JsonProperty
    public List<DataSegment> getSegments() {
        return this.segments;
    }

    @JsonProperty
    public URI getDistributedSuccessCache() {
        return this.distributedSuccessCache;
    }

    @JsonProperty
    public Map<String, String> getHadoopProperties() {
        return this.hadoopProperties;
    }

    @JsonProperty
    public String getJobPriority() {
        return this.jobPriority;
    }

    @JsonProperty
    public String getSegmentOutputPath() {
        return this.segmentOutputPath;
    }

    static {
        injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("hadoop-converter", null, null, null, true, false));
            }
        }));
        jsonMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
        jsonMapper.registerSubtypes(new Class[]{HadoopDruidConverterConfig.class});
        INDEX_IO = (IndexIO)injector.getInstance(IndexIO.class);
        INDEX_MERGER = (IndexMerger)injector.getInstance(IndexMerger.class);
        DATA_SEGMENT_PUSHER = (DataSegmentPusher)injector.getInstance(DataSegmentPusher.class);
    }
}

