/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.path;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.indexer.hadoop.FSSpideringIterator;
import org.apache.druid.indexer.path.PathSpec;
import org.apache.druid.indexer.path.StaticPathSpec;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class GranularityPathSpec
implements PathSpec {
    private static final Logger log = new Logger(GranularityPathSpec.class);
    private String inputPath;
    private String filePattern;
    private Granularity dataGranularity;
    private String pathFormat;
    private Class<? extends InputFormat> inputFormat;

    @JsonProperty
    public String getInputPath() {
        return this.inputPath;
    }

    public void setInputPath(String inputPath) {
        this.inputPath = inputPath;
    }

    @JsonProperty
    public Class<? extends InputFormat> getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(Class<? extends InputFormat> inputFormat) {
        this.inputFormat = inputFormat;
    }

    @JsonProperty
    public String getFilePattern() {
        return this.filePattern;
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    @JsonProperty
    public Granularity getDataGranularity() {
        return this.dataGranularity;
    }

    public void setDataGranularity(Granularity dataGranularity) {
        this.dataGranularity = dataGranularity;
    }

    @JsonProperty
    public String getPathFormat() {
        return this.pathFormat;
    }

    public void setPathFormat(String pathFormat) {
        this.pathFormat = pathFormat;
    }

    @Override
    public Job addInputPaths(HadoopDruidIndexerConfig config, Job job) throws IOException {
        TreeSet intervals = Sets.newTreeSet((Comparator)Comparators.intervalsByStartThenEnd());
        for (Interval inputInterval : config.getInputIntervals()) {
            for (Interval interval : this.dataGranularity.getIterable(inputInterval)) {
                intervals.add(this.trim(inputInterval, interval));
            }
        }
        Path betaInput = new Path(this.inputPath);
        FileSystem fs = betaInput.getFileSystem(job.getConfiguration());
        TreeSet paths = Sets.newTreeSet();
        Pattern fileMatcher = Pattern.compile(this.filePattern);
        DateTimeFormatter customFormatter = null;
        if (this.pathFormat != null) {
            customFormatter = DateTimeFormat.forPattern((String)this.pathFormat);
        }
        for (Interval interval : intervals) {
            DateTime t = interval.getStart();
            String intervalPath = customFormatter != null ? customFormatter.print((ReadableInstant)t) : this.dataGranularity.toPath(t);
            Path granularPath = new Path(betaInput, intervalPath);
            log.info("Checking path[%s]", new Object[]{granularPath});
            for (FileStatus status : FSSpideringIterator.spiderIterable(fs, granularPath)) {
                Path filePath = status.getPath();
                if (!fileMatcher.matcher(filePath.toString()).matches()) continue;
                paths.add(filePath.toString());
            }
        }
        log.info("Appending path %s", new Object[]{paths});
        StaticPathSpec.addToMultipleInputs(config, job, paths, this.inputFormat);
        return job;
    }

    private Interval trim(Interval inputInterval, Interval interval) {
        long start = interval.getStartMillis();
        long end = interval.getEndMillis();
        boolean makeNew = false;
        if (start < inputInterval.getStartMillis()) {
            start = inputInterval.getStartMillis();
            makeNew = true;
        }
        if (end > inputInterval.getEndMillis()) {
            end = inputInterval.getEndMillis();
            makeNew = true;
        }
        return makeNew ? new Interval(start, end, interval.getChronology()) : interval;
    }
}

