/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.Rows;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.hadoop.io.WritableUtils;

public class InputRowSerde {
    private static final Logger log = new Logger(InputRowSerde.class);
    private static final IndexSerdeTypeHelper STRING_HELPER = new StringIndexSerdeTypeHelper();
    private static final IndexSerdeTypeHelper LONG_HELPER = new LongIndexSerdeTypeHelper();
    private static final IndexSerdeTypeHelper FLOAT_HELPER = new FloatIndexSerdeTypeHelper();
    private static final IndexSerdeTypeHelper DOUBLE_HELPER = new DoubleIndexSerdeTypeHelper();

    public static Map<String, IndexSerdeTypeHelper> getTypeHelperMap(DimensionsSpec dimensionsSpec) {
        HashMap typeHelperMap = Maps.newHashMap();
        for (DimensionSchema dimensionSchema : dimensionsSpec.getDimensions()) {
            IndexSerdeTypeHelper typeHelper;
            switch (dimensionSchema.getValueType()) {
                case STRING: {
                    typeHelper = STRING_HELPER;
                    break;
                }
                case LONG: {
                    typeHelper = LONG_HELPER;
                    break;
                }
                case FLOAT: {
                    typeHelper = FLOAT_HELPER;
                    break;
                }
                case DOUBLE: {
                    typeHelper = DOUBLE_HELPER;
                    break;
                }
                default: {
                    throw new IAE("Invalid type: [%s]", new Object[]{dimensionSchema.getValueType()});
                }
            }
            typeHelperMap.put(dimensionSchema.getName(), typeHelper);
        }
        return typeHelperMap;
    }

    public static final SerializeResult toBytes(Map<String, IndexSerdeTypeHelper> typeHelperMap, InputRow row, AggregatorFactory[] aggs) {
        try {
            ArrayList<String> parseExceptionMessages = new ArrayList<String>();
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeLong(row.getTimestampFromEpoch());
            List dimList = row.getDimensions();
            WritableUtils.writeVInt((DataOutput)out, (int)dimList.size());
            for (String dim : dimList) {
                IndexSerdeTypeHelper typeHelper = typeHelperMap.get(dim);
                if (typeHelper == null) {
                    typeHelper = STRING_HELPER;
                }
                InputRowSerde.writeString(dim, out);
                try {
                    typeHelper.serialize(out, row.getRaw(dim));
                }
                catch (ParseException pe) {
                    parseExceptionMessages.add(pe.getMessage());
                }
            }
            Supplier supplier = () -> row;
            WritableUtils.writeVInt((DataOutput)out, (int)aggs.length);
            for (AggregatorFactory aggFactory : aggs) {
                String k = aggFactory.getName();
                InputRowSerde.writeString(k, out);
                try (Aggregator agg = aggFactory.factorize(IncrementalIndex.makeColumnSelectorFactory((VirtualColumns)VirtualColumns.EMPTY, (AggregatorFactory)aggFactory, (Supplier)supplier, (boolean)true));){
                    try {
                        agg.aggregate();
                    }
                    catch (ParseException e) {
                        log.debug((Throwable)e, "Encountered parse error, skipping aggregator[%s].", new Object[]{k});
                        parseExceptionMessages.add(e.getMessage());
                    }
                    String t = aggFactory.getTypeName();
                    if (agg.isNull()) {
                        out.writeByte(1);
                        continue;
                    }
                    out.writeByte(0);
                    if ("float".equals(t)) {
                        out.writeFloat(agg.getFloat());
                        continue;
                    }
                    if ("long".equals(t)) {
                        WritableUtils.writeVLong((DataOutput)out, (long)agg.getLong());
                        continue;
                    }
                    if ("double".equals(t)) {
                        out.writeDouble(agg.getDouble());
                        continue;
                    }
                    Object val = agg.get();
                    ComplexMetricSerde serde = InputRowSerde.getComplexMetricSerde(t);
                    InputRowSerde.writeBytes(serde.toBytes(val), out);
                }
            }
            return new SerializeResult(out.toByteArray(), parseExceptionMessages);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void writeBytes(@Nullable byte[] value, ByteArrayDataOutput out) throws IOException {
        int length = value == null ? -1 : value.length;
        WritableUtils.writeVInt((DataOutput)out, (int)length);
        if (value != null) {
            out.write(value, 0, value.length);
        }
    }

    private static void writeString(String value, ByteArrayDataOutput out) throws IOException {
        InputRowSerde.writeBytes(StringUtils.toUtf8((String)value), out);
    }

    private static void writeStringArray(List<String> values, ByteArrayDataOutput out) throws IOException {
        if (values == null || values.size() == 0) {
            WritableUtils.writeVInt((DataOutput)out, (int)0);
            return;
        }
        WritableUtils.writeVInt((DataOutput)out, (int)values.size());
        for (String value : values) {
            InputRowSerde.writeString(value, out);
        }
    }

    private static String readString(DataInput in) throws IOException {
        byte[] result = InputRowSerde.readBytes(in);
        return StringUtils.fromUtf8((byte[])result);
    }

    private static byte[] readBytes(DataInput in) throws IOException {
        int size = WritableUtils.readVInt((DataInput)in);
        byte[] result = new byte[size];
        in.readFully(result, 0, size);
        return result;
    }

    private static List<String> readStringArray(DataInput in) throws IOException {
        int count = WritableUtils.readVInt((DataInput)in);
        if (count == 0) {
            return null;
        }
        ArrayList values = Lists.newArrayListWithCapacity((int)count);
        for (int i = 0; i < count; ++i) {
            values.add(InputRowSerde.readString(in));
        }
        return values;
    }

    public static final InputRow fromBytes(Map<String, IndexSerdeTypeHelper> typeHelperMap, byte[] data, AggregatorFactory[] aggs) {
        try {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            long timestamp = in.readLong();
            HashMap event = Maps.newHashMap();
            ArrayList dimensions = Lists.newArrayList();
            int dimNum = WritableUtils.readVInt((DataInput)in);
            for (int i = 0; i < dimNum; ++i) {
                Object dimValues;
                String dimension = InputRowSerde.readString((DataInput)in);
                dimensions.add(dimension);
                IndexSerdeTypeHelper typeHelper = typeHelperMap.get(dimension);
                if (typeHelper == null) {
                    typeHelper = STRING_HELPER;
                }
                if ((dimValues = typeHelper.deserialize(in)) == null) continue;
                if (typeHelper.getType() == ValueType.STRING) {
                    List dimensionValues = (List)dimValues;
                    if (dimensionValues.size() == 1) {
                        event.put(dimension, dimensionValues.get(0));
                        continue;
                    }
                    event.put(dimension, dimensionValues);
                    continue;
                }
                event.put(dimension, dimValues);
            }
            int metricSize = WritableUtils.readVInt((DataInput)in);
            for (int i = 0; i < metricSize; ++i) {
                String metric = InputRowSerde.readString((DataInput)in);
                String type = InputRowSerde.getType(metric, aggs, i);
                byte metricNullability = in.readByte();
                if (metricNullability == 1) continue;
                if ("float".equals(type)) {
                    event.put(metric, Float.valueOf(in.readFloat()));
                    continue;
                }
                if ("long".equals(type)) {
                    event.put(metric, WritableUtils.readVLong((DataInput)in));
                    continue;
                }
                if ("double".equals(type)) {
                    event.put(metric, in.readDouble());
                    continue;
                }
                ComplexMetricSerde serde = InputRowSerde.getComplexMetricSerde(type);
                byte[] value = InputRowSerde.readBytes((DataInput)in);
                event.put(metric, serde.fromBytes(value, 0, value.length));
            }
            return new MapBasedInputRow(timestamp, (List)dimensions, (Map)event);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String getType(String metric, AggregatorFactory[] aggs, int i) {
        if (aggs[i].getName().equals(metric)) {
            return aggs[i].getTypeName();
        }
        log.warn("Aggs disordered, fall backs to loop.", new Object[0]);
        for (AggregatorFactory agg : aggs) {
            if (!agg.getName().equals(metric)) continue;
            return agg.getTypeName();
        }
        return null;
    }

    private static ComplexMetricSerde getComplexMetricSerde(String type) {
        ComplexMetricSerde serde = ComplexMetrics.getSerdeForType((String)type);
        if (serde == null) {
            throw new IAE("Unknown type[%s]", new Object[]{type});
        }
        return serde;
    }

    public static class DoubleIndexSerdeTypeHelper
    implements IndexSerdeTypeHelper<Double> {
        @Override
        public ValueType getType() {
            return ValueType.DOUBLE;
        }

        @Override
        public void serialize(ByteArrayDataOutput out, Object value) {
            ParseException exceptionToThrow = null;
            Double ret = null;
            try {
                ret = DimensionHandlerUtils.convertObjectToDouble((Object)value, (boolean)true);
            }
            catch (ParseException pe) {
                exceptionToThrow = pe;
            }
            if (ret == null) {
                ret = DimensionHandlerUtils.ZERO_DOUBLE;
            }
            out.writeDouble(ret.doubleValue());
            if (exceptionToThrow != null) {
                throw exceptionToThrow;
            }
        }

        @Override
        public Double deserialize(ByteArrayDataInput in) {
            return in.readDouble();
        }
    }

    public static class FloatIndexSerdeTypeHelper
    implements IndexSerdeTypeHelper<Float> {
        @Override
        public ValueType getType() {
            return ValueType.FLOAT;
        }

        @Override
        public void serialize(ByteArrayDataOutput out, Object value) {
            ParseException exceptionToThrow = null;
            Float ret = null;
            try {
                ret = DimensionHandlerUtils.convertObjectToFloat((Object)value, (boolean)true);
            }
            catch (ParseException pe) {
                exceptionToThrow = pe;
            }
            if (ret == null) {
                ret = DimensionHandlerUtils.ZERO_FLOAT;
            }
            out.writeFloat(ret.floatValue());
            if (exceptionToThrow != null) {
                throw exceptionToThrow;
            }
        }

        @Override
        public Float deserialize(ByteArrayDataInput in) {
            return Float.valueOf(in.readFloat());
        }
    }

    public static class LongIndexSerdeTypeHelper
    implements IndexSerdeTypeHelper<Long> {
        @Override
        public ValueType getType() {
            return ValueType.LONG;
        }

        @Override
        public void serialize(ByteArrayDataOutput out, Object value) {
            ParseException exceptionToThrow = null;
            Long ret = null;
            try {
                ret = DimensionHandlerUtils.convertObjectToLong((Object)value, (boolean)true);
            }
            catch (ParseException pe) {
                exceptionToThrow = pe;
            }
            if (ret == null) {
                ret = DimensionHandlerUtils.ZERO_LONG;
            }
            out.writeLong(ret.longValue());
            if (exceptionToThrow != null) {
                throw exceptionToThrow;
            }
        }

        @Override
        public Long deserialize(ByteArrayDataInput in) {
            return in.readLong();
        }
    }

    public static class StringIndexSerdeTypeHelper
    implements IndexSerdeTypeHelper<List<String>> {
        @Override
        public ValueType getType() {
            return ValueType.STRING;
        }

        @Override
        public void serialize(ByteArrayDataOutput out, Object value) {
            List values = Rows.objectToStrings((Object)value);
            try {
                InputRowSerde.writeStringArray(values, out);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        @Override
        public List<String> deserialize(ByteArrayDataInput in) {
            try {
                return InputRowSerde.readStringArray((DataInput)in);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public static class SerializeResult {
        private final byte[] serializedRow;
        private final List<String> parseExceptionMessages;

        public SerializeResult(byte[] serializedRow, List<String> parseExceptionMessages) {
            this.serializedRow = serializedRow;
            this.parseExceptionMessages = parseExceptionMessages;
        }

        public byte[] getSerializedRow() {
            return this.serializedRow;
        }

        public List<String> getParseExceptionMessages() {
            return this.parseExceptionMessages;
        }
    }

    public static interface IndexSerdeTypeHelper<T> {
        public ValueType getType();

        public void serialize(ByteArrayDataOutput var1, Object var2);

        public T deserialize(ByteArrayDataInput var1);
    }
}

