/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.indexer.HadoopyShardSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.indexing.TuningConfig;

@JsonTypeName(value="hadoop")
public class HadoopTuningConfig
implements TuningConfig {
    private static final PartitionsSpec DEFAULT_PARTITIONS_SPEC = HashedPartitionsSpec.makeDefaultHashedPartitionsSpec();
    private static final Map<Long, List<HadoopyShardSpec>> DEFAULT_SHARD_SPECS = ImmutableMap.of();
    private static final IndexSpec DEFAULT_INDEX_SPEC = new IndexSpec();
    private static final int DEFAULT_ROW_FLUSH_BOUNDARY = 1000000;
    private static final boolean DEFAULT_USE_COMBINER = false;
    private static final int DEFAULT_NUM_BACKGROUND_PERSIST_THREADS = 0;
    private final String workingPath;
    private final String version;
    private final PartitionsSpec partitionsSpec;
    private final Map<Long, List<HadoopyShardSpec>> shardSpecs;
    private final IndexSpec indexSpec;
    private final int rowFlushBoundary;
    private final long maxBytesInMemory;
    private final boolean leaveIntermediate;
    private final Boolean cleanupOnFailure;
    private final boolean overwriteFiles;
    private final Boolean ignoreInvalidRows;
    private final Map<String, String> jobProperties;
    private final boolean combineText;
    private final boolean useCombiner;
    private final int numBackgroundPersistThreads;
    private final boolean forceExtendableShardSpecs;
    private final boolean useExplicitVersion;
    private final List<String> allowedHadoopPrefix;
    private final boolean logParseExceptions;
    private final int maxParseExceptions;

    public static HadoopTuningConfig makeDefaultTuningConfig() {
        return new HadoopTuningConfig(null, DateTimes.nowUtc().toString(), DEFAULT_PARTITIONS_SPEC, DEFAULT_SHARD_SPECS, DEFAULT_INDEX_SPEC, 1000000, 0L, false, true, false, false, null, false, false, null, true, 0, false, false, null, null, null);
    }

    @JsonCreator
    public HadoopTuningConfig(@JsonProperty(value="workingPath") String workingPath, @JsonProperty(value="version") String version, @JsonProperty(value="partitionsSpec") PartitionsSpec partitionsSpec, @JsonProperty(value="shardSpecs") Map<Long, List<HadoopyShardSpec>> shardSpecs, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="maxRowsInMemory") Integer maxRowsInMemory, @JsonProperty(value="maxBytesInMemory") Long maxBytesInMemory, @JsonProperty(value="leaveIntermediate") boolean leaveIntermediate, @JsonProperty(value="cleanupOnFailure") Boolean cleanupOnFailure, @JsonProperty(value="overwriteFiles") boolean overwriteFiles, @Deprecated @JsonProperty(value="ignoreInvalidRows") Boolean ignoreInvalidRows, @JsonProperty(value="jobProperties") Map<String, String> jobProperties, @JsonProperty(value="combineText") boolean combineText, @JsonProperty(value="useCombiner") Boolean useCombiner, @JsonProperty(value="rowFlushBoundary") Integer maxRowsInMemoryCOMPAT, @JsonProperty(value="buildV9Directly") Boolean buildV9Directly, @JsonProperty(value="numBackgroundPersistThreads") Integer numBackgroundPersistThreads, @JsonProperty(value="forceExtendableShardSpecs") boolean forceExtendableShardSpecs, @JsonProperty(value="useExplicitVersion") boolean useExplicitVersion, @JsonProperty(value="allowedHadoopPrefix") List<String> allowedHadoopPrefix, @JsonProperty(value="logParseExceptions") @Nullable Boolean logParseExceptions, @JsonProperty(value="maxParseExceptions") @Nullable Integer maxParseExceptions) {
        this.workingPath = workingPath;
        this.version = version == null ? DateTimes.nowUtc().toString() : version;
        this.partitionsSpec = partitionsSpec == null ? DEFAULT_PARTITIONS_SPEC : partitionsSpec;
        this.shardSpecs = shardSpecs == null ? DEFAULT_SHARD_SPECS : shardSpecs;
        IndexSpec indexSpec2 = this.indexSpec = indexSpec == null ? DEFAULT_INDEX_SPEC : indexSpec;
        this.rowFlushBoundary = maxRowsInMemory == null ? (maxRowsInMemoryCOMPAT == null ? 1000000 : maxRowsInMemoryCOMPAT) : maxRowsInMemory;
        this.maxBytesInMemory = maxBytesInMemory == null ? 0L : maxBytesInMemory;
        this.leaveIntermediate = leaveIntermediate;
        this.cleanupOnFailure = cleanupOnFailure == null ? true : cleanupOnFailure;
        this.overwriteFiles = overwriteFiles;
        this.jobProperties = jobProperties == null ? ImmutableMap.of() : ImmutableMap.copyOf(jobProperties);
        this.combineText = combineText;
        this.useCombiner = useCombiner == null ? false : useCombiner;
        this.numBackgroundPersistThreads = numBackgroundPersistThreads == null ? 0 : numBackgroundPersistThreads;
        this.forceExtendableShardSpecs = forceExtendableShardSpecs;
        Preconditions.checkArgument((this.numBackgroundPersistThreads >= 0 ? 1 : 0) != 0, (Object)"Not support persistBackgroundCount < 0");
        this.useExplicitVersion = useExplicitVersion;
        this.allowedHadoopPrefix = allowedHadoopPrefix == null ? ImmutableList.of() : allowedHadoopPrefix;
        this.ignoreInvalidRows = ignoreInvalidRows == null ? false : ignoreInvalidRows;
        this.maxParseExceptions = maxParseExceptions != null ? maxParseExceptions : (this.ignoreInvalidRows == false ? 0 : Integer.MAX_VALUE);
        this.logParseExceptions = logParseExceptions == null ? false : logParseExceptions;
    }

    @JsonProperty
    public String getWorkingPath() {
        return this.workingPath;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    public PartitionsSpec getPartitionsSpec() {
        return this.partitionsSpec;
    }

    @JsonProperty
    public Map<Long, List<HadoopyShardSpec>> getShardSpecs() {
        return this.shardSpecs;
    }

    @JsonProperty
    public IndexSpec getIndexSpec() {
        return this.indexSpec;
    }

    @JsonProperty(value="maxRowsInMemory")
    public int getRowFlushBoundary() {
        return this.rowFlushBoundary;
    }

    @JsonProperty
    public long getMaxBytesInMemory() {
        return this.maxBytesInMemory;
    }

    @JsonProperty
    public boolean isLeaveIntermediate() {
        return this.leaveIntermediate;
    }

    @JsonProperty
    public Boolean isCleanupOnFailure() {
        return this.cleanupOnFailure;
    }

    @JsonProperty
    public boolean isOverwriteFiles() {
        return this.overwriteFiles;
    }

    @JsonProperty
    public Boolean isIgnoreInvalidRows() {
        return this.ignoreInvalidRows;
    }

    @JsonProperty
    public Map<String, String> getJobProperties() {
        return this.jobProperties;
    }

    @JsonProperty
    public boolean isCombineText() {
        return this.combineText;
    }

    @JsonProperty
    public boolean getUseCombiner() {
        return this.useCombiner;
    }

    @Deprecated
    @JsonProperty
    public Boolean getBuildV9Directly() {
        return true;
    }

    @JsonProperty
    public int getNumBackgroundPersistThreads() {
        return this.numBackgroundPersistThreads;
    }

    @JsonProperty
    public boolean isForceExtendableShardSpecs() {
        return this.forceExtendableShardSpecs;
    }

    @JsonProperty
    public boolean isUseExplicitVersion() {
        return this.useExplicitVersion;
    }

    @JsonProperty(value="allowedHadoopPrefix")
    public List<String> getUserAllowedHadoopPrefix() {
        return this.allowedHadoopPrefix;
    }

    @JsonProperty
    public boolean isLogParseExceptions() {
        return this.logParseExceptions;
    }

    @JsonProperty
    public int getMaxParseExceptions() {
        return this.maxParseExceptions;
    }

    public HadoopTuningConfig withWorkingPath(String path) {
        return new HadoopTuningConfig(path, this.version, this.partitionsSpec, this.shardSpecs, this.indexSpec, this.rowFlushBoundary, this.maxBytesInMemory, this.leaveIntermediate, this.cleanupOnFailure, this.overwriteFiles, this.ignoreInvalidRows, this.jobProperties, this.combineText, this.useCombiner, null, true, this.numBackgroundPersistThreads, this.forceExtendableShardSpecs, this.useExplicitVersion, this.allowedHadoopPrefix, this.logParseExceptions, this.maxParseExceptions);
    }

    public HadoopTuningConfig withVersion(String ver) {
        return new HadoopTuningConfig(this.workingPath, ver, this.partitionsSpec, this.shardSpecs, this.indexSpec, this.rowFlushBoundary, this.maxBytesInMemory, this.leaveIntermediate, this.cleanupOnFailure, this.overwriteFiles, this.ignoreInvalidRows, this.jobProperties, this.combineText, this.useCombiner, null, true, this.numBackgroundPersistThreads, this.forceExtendableShardSpecs, this.useExplicitVersion, this.allowedHadoopPrefix, this.logParseExceptions, this.maxParseExceptions);
    }

    public HadoopTuningConfig withShardSpecs(Map<Long, List<HadoopyShardSpec>> specs) {
        return new HadoopTuningConfig(this.workingPath, this.version, this.partitionsSpec, specs, this.indexSpec, this.rowFlushBoundary, this.maxBytesInMemory, this.leaveIntermediate, this.cleanupOnFailure, this.overwriteFiles, this.ignoreInvalidRows, this.jobProperties, this.combineText, this.useCombiner, null, true, this.numBackgroundPersistThreads, this.forceExtendableShardSpecs, this.useExplicitVersion, this.allowedHadoopPrefix, this.logParseExceptions, this.maxParseExceptions);
    }
}

