/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.druid.common.utils.UUIDUtils;
import org.apache.druid.indexer.HadoopIOConfig;
import org.apache.druid.indexer.HadoopTuningConfig;
import org.apache.druid.indexer.hadoop.DatasourceIngestionSpec;
import org.apache.druid.indexer.hadoop.WindowedDataSegment;
import org.apache.druid.indexer.path.UsedSegmentLister;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.IOConfig;
import org.apache.druid.segment.indexing.IngestionSpec;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.joda.time.Interval;

public class HadoopIngestionSpec
extends IngestionSpec<HadoopIOConfig, HadoopTuningConfig> {
    private final DataSchema dataSchema;
    private final HadoopIOConfig ioConfig;
    private final HadoopTuningConfig tuningConfig;
    private final String uniqueId;

    @JsonCreator
    public HadoopIngestionSpec(@JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="ioConfig") HadoopIOConfig ioConfig, @JsonProperty(value="tuningConfig") HadoopTuningConfig tuningConfig, @JsonProperty(value="uniqueId") String uniqueId) {
        super(dataSchema, (IOConfig)ioConfig, (TuningConfig)tuningConfig);
        this.dataSchema = dataSchema;
        this.ioConfig = ioConfig;
        this.tuningConfig = tuningConfig == null ? HadoopTuningConfig.makeDefaultTuningConfig() : tuningConfig;
        this.uniqueId = uniqueId == null ? UUIDUtils.generateUuid((String[])new String[0]) : uniqueId;
    }

    public HadoopIngestionSpec(DataSchema dataSchema, HadoopIOConfig ioConfig, HadoopTuningConfig tuningConfig) {
        this(dataSchema, ioConfig, tuningConfig, null);
    }

    @JsonProperty(value="dataSchema")
    public DataSchema getDataSchema() {
        return this.dataSchema;
    }

    @JsonProperty(value="ioConfig")
    public HadoopIOConfig getIOConfig() {
        return this.ioConfig;
    }

    @JsonProperty(value="tuningConfig")
    public HadoopTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    @JsonProperty(value="uniqueId")
    public String getUniqueId() {
        return this.uniqueId;
    }

    public HadoopIngestionSpec withDataSchema(DataSchema schema) {
        return new HadoopIngestionSpec(schema, this.ioConfig, this.tuningConfig, this.uniqueId);
    }

    public HadoopIngestionSpec withIOConfig(HadoopIOConfig config) {
        return new HadoopIngestionSpec(this.dataSchema, config, this.tuningConfig, this.uniqueId);
    }

    public HadoopIngestionSpec withTuningConfig(HadoopTuningConfig config) {
        return new HadoopIngestionSpec(this.dataSchema, this.ioConfig, config, this.uniqueId);
    }

    public static HadoopIngestionSpec updateSegmentListIfDatasourcePathSpecIsUsed(HadoopIngestionSpec spec, ObjectMapper jsonMapper, UsedSegmentLister segmentLister) throws IOException {
        String dataSource = "dataSource";
        String type = "type";
        String multi = "multi";
        String children = "children";
        String segments = "segments";
        String ingestionSpec = "ingestionSpec";
        Map<String, Object> pathSpec = spec.getIOConfig().getPathSpec();
        ArrayList<Map> datasourcePathSpecs = new ArrayList<Map>();
        if (pathSpec.get(type).equals(dataSource)) {
            datasourcePathSpecs.add(pathSpec);
        } else if (pathSpec.get(type).equals(multi)) {
            List childPathSpecs = (List)pathSpec.get(children);
            for (Map childPathSpec : childPathSpecs) {
                if (!childPathSpec.get(type).equals(dataSource)) continue;
                datasourcePathSpecs.add(childPathSpec);
            }
        }
        for (Map datasourcePathSpec : datasourcePathSpecs) {
            Map ingestionSpecMap = (Map)datasourcePathSpec.get(ingestionSpec);
            DatasourceIngestionSpec ingestionSpecObj = (DatasourceIngestionSpec)jsonMapper.convertValue((Object)ingestionSpecMap, DatasourceIngestionSpec.class);
            List<DataSegment> segmentsList = segmentLister.getUsedSegmentsForIntervals(ingestionSpecObj.getDataSource(), ingestionSpecObj.getIntervals());
            if (ingestionSpecObj.getSegments() != null) {
                List<DataSegment> userSuppliedSegmentsList = ingestionSpecObj.getSegments();
                if (segmentsList.size() == userSuppliedSegmentsList.size()) {
                    HashSet<DataSegment> segmentsSet = new HashSet<DataSegment>(segmentsList);
                    for (DataSegment userSegment : userSuppliedSegmentsList) {
                        if (segmentsSet.contains(userSegment)) continue;
                        throw new IOException("user supplied segments list did not match with segments list obtained from db");
                    }
                } else {
                    throw new IOException("user supplied segments list did not match with segments list obtained from db");
                }
            }
            VersionedIntervalTimeline timeline = VersionedIntervalTimeline.forSegments(segmentsList);
            ArrayList windowedSegments = Lists.newArrayList();
            for (Interval interval : ingestionSpecObj.getIntervals()) {
                List timeLineSegments = timeline.lookup(interval);
                for (TimelineObjectHolder holder : timeLineSegments) {
                    for (PartitionChunk chunk : holder.getObject()) {
                        windowedSegments.add(new WindowedDataSegment((DataSegment)chunk.getObject(), holder.getInterval()));
                    }
                }
                datasourcePathSpec.put(segments, windowedSegments);
            }
        }
        return spec;
    }
}

