/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.indexer.HadoopyShardSpec;
import org.apache.druid.indexer.JobHelper;
import org.apache.druid.indexer.Jobby;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class HadoopDruidDetermineConfigurationJob
implements Jobby {
    private static final Logger log = new Logger(HadoopDruidDetermineConfigurationJob.class);
    private final HadoopDruidIndexerConfig config;
    private Jobby job;

    @Inject
    public HadoopDruidDetermineConfigurationJob(HadoopDruidIndexerConfig config) {
        this.config = config;
    }

    public boolean run() {
        JobHelper.ensurePaths(this.config);
        if (this.config.isDeterminingPartitions()) {
            this.job = this.config.getPartitionsSpec().getPartitionJob(this.config);
            return JobHelper.runSingleJob(this.job, this.config);
        }
        int shardsPerInterval = this.config.getPartitionsSpec().getNumShards();
        TreeMap shardSpecs = Maps.newTreeMap();
        int shardCount = 0;
        for (Interval segmentGranularity : (Set)this.config.getSegmentGranularIntervals().get()) {
            DateTime bucket = segmentGranularity.getStart();
            if (shardsPerInterval > 0) {
                ArrayList specs = Lists.newArrayListWithCapacity((int)shardsPerInterval);
                for (int i = 0; i < shardsPerInterval; ++i) {
                    specs.add(new HadoopyShardSpec((ShardSpec)new HashBasedNumberedShardSpec(i, shardsPerInterval, this.config.getPartitionsSpec().getPartitionDimensions(), HadoopDruidIndexerConfig.JSON_MAPPER), shardCount++));
                }
                shardSpecs.put(bucket.getMillis(), specs);
                log.info("DateTime[%s], spec[%s]", new Object[]{bucket, specs});
                continue;
            }
            HadoopyShardSpec spec = new HadoopyShardSpec((ShardSpec)NoneShardSpec.instance(), shardCount++);
            shardSpecs.put(bucket.getMillis(), Collections.singletonList(spec));
            log.info("DateTime[%s], spec[%s]", new Object[]{bucket, spec});
        }
        this.config.setShardSpecs(shardSpecs);
        return true;
    }

    public Map<String, Object> getStats() {
        if (this.job == null) {
            return null;
        }
        return this.job.getStats();
    }

    public String getErrorMessage() {
        if (this.job == null) {
            return null;
        }
        return this.job.getErrorMessage();
    }
}

