/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.utils;

import com.google.inject.Inject;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.StringTokenizer;
import org.apache.druid.utils.RuntimeInfo;

public class JvmUtils {
    private static final boolean IS_JAVA9_COMPATIBLE = JvmUtils.isJava9Compatible(System.getProperty("java.specification.version"));
    @Inject
    private static RuntimeInfo runtimeInfo = new RuntimeInfo();
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();

    private static boolean isJava9Compatible(String versionString) {
        StringTokenizer st = new StringTokenizer(versionString, ".");
        int majorVersion = Integer.parseInt(st.nextToken());
        return majorVersion >= 9;
    }

    public static boolean isIsJava9Compatible() {
        return IS_JAVA9_COMPATIBLE;
    }

    public static RuntimeInfo getRuntimeInfo() {
        return runtimeInfo;
    }

    public static boolean isThreadCpuTimeEnabled() {
        return THREAD_MX_BEAN.isThreadCpuTimeSupported() && THREAD_MX_BEAN.isThreadCpuTimeEnabled();
    }

    public static long safeGetThreadCpuTime() {
        if (!JvmUtils.isThreadCpuTimeEnabled()) {
            return 0L;
        }
        return JvmUtils.getCurrentThreadCpuTime();
    }

    public static long getCurrentThreadCpuTime() {
        return THREAD_MX_BEAN.getCurrentThreadCpuTime();
    }
}

