/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.utils;

import com.google.common.collect.Maps;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class CollectionUtils {
    public static <E> Collection<E> createLazyCollectionFromStream(final Supplier<Stream<E>> sequentialStreamSupplier, final int size) {
        return new AbstractCollection<E>(){

            @Override
            public Iterator<E> iterator() {
                return ((Stream)sequentialStreamSupplier.get()).iterator();
            }

            @Override
            public Spliterator<E> spliterator() {
                return ((Stream)sequentialStreamSupplier.get()).spliterator();
            }

            @Override
            public Stream<E> stream() {
                return (Stream)sequentialStreamSupplier.get();
            }

            @Override
            public Stream<E> parallelStream() {
                return (Stream)((Stream)sequentialStreamSupplier.get()).parallel();
            }

            @Override
            public int size() {
                return size;
            }
        };
    }

    public static <K, V, V2> Map<K, V2> mapValues(Map<K, V> map, Function<V, V2> valueMapper) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)map.size());
        map.forEach((k, v) -> result.put(k, valueMapper.apply(v)));
        return result;
    }

    private CollectionUtils() {
    }
}

