/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Spliterator;
import java.util.TreeSet;
import org.apache.druid.timeline.partition.PartitionChunk;

public class PartitionHolder<T>
implements Iterable<PartitionChunk<T>> {
    private final TreeSet<PartitionChunk<T>> holderSet = new TreeSet();

    public PartitionHolder(PartitionChunk<T> initialChunk) {
        this.add(initialChunk);
    }

    public PartitionHolder(List<PartitionChunk<T>> initialChunks) {
        for (PartitionChunk<T> chunk : initialChunks) {
            this.add(chunk);
        }
    }

    public PartitionHolder(PartitionHolder partitionHolder) {
        this.holderSet.addAll(partitionHolder.holderSet);
    }

    public void add(PartitionChunk<T> chunk) {
        this.holderSet.add(chunk);
    }

    public PartitionChunk<T> remove(PartitionChunk<T> chunk) {
        PartitionChunk element;
        NavigableSet<PartitionChunk<T>> tailSet;
        if (!this.holderSet.isEmpty() && !(tailSet = this.holderSet.tailSet(chunk, true)).isEmpty() && chunk.equals(element = (PartitionChunk)tailSet.first())) {
            this.holderSet.remove(element);
            return element;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.holderSet.isEmpty();
    }

    public boolean isComplete() {
        if (this.holderSet.isEmpty()) {
            return false;
        }
        Iterator<PartitionChunk<T>> iter = this.holderSet.iterator();
        PartitionChunk<T> curr = iter.next();
        if (!curr.isStart()) {
            return false;
        }
        if (curr.isEnd()) {
            return true;
        }
        while (iter.hasNext()) {
            PartitionChunk<T> next = iter.next();
            if (!curr.abuts(next)) {
                return false;
            }
            if (next.isEnd()) {
                return true;
            }
            curr = next;
        }
        return false;
    }

    public PartitionChunk<T> getChunk(int partitionNum) {
        UnmodifiableIterator retVal = Iterators.filter(this.holderSet.iterator(), input -> input.getChunkNumber() == partitionNum);
        return retVal.hasNext() ? (PartitionChunk)retVal.next() : null;
    }

    @Override
    public Iterator<PartitionChunk<T>> iterator() {
        return this.holderSet.iterator();
    }

    @Override
    public Spliterator<PartitionChunk<T>> spliterator() {
        return this.holderSet.spliterator();
    }

    public Iterable<T> payloads() {
        return Iterables.transform((Iterable)this, PartitionChunk::getObject);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionHolder that = (PartitionHolder)o;
        return this.holderSet.equals(that.holderSet);
    }

    public int hashCode() {
        return this.holderSet.hashCode();
    }

    public String toString() {
        return "PartitionHolder{holderSet=" + this.holderSet + '}';
    }
}

