/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import javax.annotation.Nonnull;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.UnaryExpr;

class UnaryNotExpr
extends UnaryExpr {
    UnaryNotExpr(Expr expr) {
        super(expr);
    }

    @Override
    @Nonnull
    public ExprEval eval(Expr.ObjectBinding bindings) {
        ExprEval ret = this.expr.eval(bindings);
        if (NullHandling.sqlCompatible() && ret.value() == null) {
            return ExprEval.of(null);
        }
        ExprType retType = ret.type() == ExprType.DOUBLE ? ExprType.DOUBLE : ExprType.LONG;
        return ExprEval.of(!ret.asBoolean(), retType);
    }

    public String toString() {
        return "!" + this.expr;
    }
}

