/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.service;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.joda.time.DateTime;

public class ServiceMetricEvent
implements Event {
    private final DateTime createdTime;
    private final ImmutableMap<String, String> serviceDims;
    private final Map<String, Object> userDims;
    private final String feed;
    private final String metric;
    private final Number value;

    public static Builder builder() {
        return new Builder();
    }

    private ServiceMetricEvent(DateTime createdTime, ImmutableMap<String, String> serviceDims, Map<String, Object> userDims, String feed, String metric, Number value) {
        this.createdTime = createdTime != null ? createdTime : DateTimes.nowUtc();
        this.serviceDims = serviceDims;
        this.userDims = userDims;
        this.feed = feed;
        this.metric = metric;
        this.value = value;
    }

    public DateTime getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public String getFeed() {
        return this.feed;
    }

    public String getService() {
        return (String)this.serviceDims.get((Object)"service");
    }

    public String getHost() {
        return (String)this.serviceDims.get((Object)"host");
    }

    public Map<String, Object> getUserDims() {
        return ImmutableMap.copyOf(this.userDims);
    }

    public String getMetric() {
        return this.metric;
    }

    public Number getValue() {
        return this.value;
    }

    @Override
    @JsonValue
    public Map<String, Object> toMap() {
        return ImmutableMap.builder().put((Object)"feed", (Object)this.getFeed()).put((Object)"timestamp", (Object)this.createdTime.toString()).putAll(this.serviceDims).put((Object)"metric", (Object)this.metric).put((Object)"value", (Object)this.value).putAll(Maps.filterEntries(this.userDims, (Predicate)new Predicate<Map.Entry<String, Object>>(){

            public boolean apply(Map.Entry<String, Object> input) {
                return input.getKey() != null;
            }
        })).build();
    }

    public static class Builder {
        private final Map<String, Object> userDims = new TreeMap<String, Object>();
        private String feed = "metrics";

        public Builder setFeed(String feed) {
            this.feed = feed;
            return this;
        }

        public Builder setDimension(String dim, String[] values) {
            this.userDims.put(dim, Arrays.asList(values));
            return this;
        }

        public Builder setDimension(String dim, String value) {
            this.userDims.put(dim, value);
            return this;
        }

        public Object getDimension(String dim) {
            return this.userDims.get(dim);
        }

        public ServiceEventBuilder<ServiceMetricEvent> build(String metric, Number value) {
            return this.build(null, metric, value);
        }

        public ServiceEventBuilder<ServiceMetricEvent> build(final DateTime createdTime, final String metric, final Number value) {
            if (Double.isNaN(value.doubleValue())) {
                throw new ISE("Value of NaN is not allowed!", new Object[0]);
            }
            if (Double.isInfinite(value.doubleValue())) {
                throw new ISE("Value of Infinite is not allowed!", new Object[0]);
            }
            return new ServiceEventBuilder<ServiceMetricEvent>(){

                @Override
                public ServiceMetricEvent build(ImmutableMap<String, String> serviceDimensions) {
                    return new ServiceMetricEvent(createdTime, serviceDimensions, userDims, feed, metric, value);
                }
            };
        }
    }
}

