/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;

public class ServiceEmitter
implements Emitter {
    private final ImmutableMap<String, String> serviceDimensions;
    private final Emitter emitter;

    public ServiceEmitter(String service, String host, Emitter emitter) {
        this(service, host, emitter, (ImmutableMap<String, String>)ImmutableMap.of());
    }

    public ServiceEmitter(String service, String host, Emitter emitter, ImmutableMap<String, String> otherServiceDimensions) {
        this.serviceDimensions = ImmutableMap.builder().put((Object)"service", Preconditions.checkNotNull((Object)service)).put((Object)"host", Preconditions.checkNotNull((Object)host)).putAll(otherServiceDimensions).build();
        this.emitter = emitter;
    }

    @Override
    @LifecycleStart
    public void start() {
        this.emitter.start();
    }

    @Override
    public void emit(Event event) {
        this.emitter.emit(event);
    }

    public void emit(ServiceEventBuilder builder) {
        this.emit((Event)builder.build(this.serviceDimensions));
    }

    @Override
    public void flush() throws IOException {
        this.emitter.flush();
    }

    @Override
    @LifecycleStop
    public void close() throws IOException {
        this.emitter.close();
    }

    public String toString() {
        return "ServiceEmitter{serviceDimensions=" + this.serviceDimensions + ", emitter=" + this.emitter + '}';
    }
}

