/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.primitives.Ints;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.apache.druid.concurrent.ConcurrentAwaitableCounter;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.core.Batch;
import org.apache.druid.java.util.emitter.core.BatchingStrategy;
import org.apache.druid.java.util.emitter.core.ConcurrentTimeCounter;
import org.apache.druid.java.util.emitter.core.ContentEncoding;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.core.HttpEmitterConfig;
import org.apache.druid.java.util.emitter.core.ZeroCopyByteArrayOutputStream;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;

public class HttpPostEmitter
implements Flushable,
Closeable,
Emitter {
    private static final int MAX_EVENT_SIZE = 1047552;
    private static final int MAX_SEND_RETRIES = 3;
    private static final int EMIT_QUEUE_THRESHOLD_1 = 5;
    private static final int EMIT_QUEUE_THRESHOLD_2 = 10;
    private static final double EQUILIBRIUM_ALLOWANCE_FACTOR = 0.9;
    private static final double TIGHT_ALLOWANCE_FACTOR = 0.5;
    private static final byte[] LARGE_EVENTS_STOP = new byte[0];
    private static final Logger log = new Logger(HttpPostEmitter.class);
    private static final AtomicInteger instanceCounter = new AtomicInteger();
    final BatchingStrategy batchingStrategy;
    final HttpEmitterConfig config;
    private final int bufferSize;
    final int maxBufferWatermark;
    private final int largeEventThreshold;
    private final AsyncHttpClient client;
    private final ObjectMapper jsonMapper;
    private final String url;
    private final ConcurrentLinkedQueue<byte[]> buffersToReuse = new ConcurrentLinkedQueue();
    private final AtomicInteger approximateBuffersToReuseCount = new AtomicInteger();
    private final AtomicReference<Object> concurrentBatch = new AtomicReference();
    private final ConcurrentLinkedDeque<Batch> buffersToEmit = new ConcurrentLinkedDeque();
    private final AtomicInteger approximateBuffersToEmitCount = new AtomicInteger();
    private final AtomicLong approximateEventsToEmitCount = new AtomicLong();
    private final ConcurrentLinkedQueue<byte[]> largeEventsToEmit = new ConcurrentLinkedQueue();
    private final AtomicInteger approximateLargeEventsToEmitCount = new AtomicInteger();
    private final ConcurrentAwaitableCounter emittedBatchCounter = new ConcurrentAwaitableCounter();
    private final EmittingThread emittingThread;
    private final AtomicLong totalEmittedEvents = new AtomicLong();
    private final AtomicInteger allocatedBuffers = new AtomicInteger();
    private final AtomicInteger droppedBuffers = new AtomicInteger();
    private volatile long lastBatchFillTimeMillis;
    private final ConcurrentTimeCounter batchFillingTimeCounter = new ConcurrentTimeCounter();
    private final Object startLock = new Object();
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private boolean running = false;

    public HttpPostEmitter(HttpEmitterConfig config, AsyncHttpClient client) {
        this(config, client, new ObjectMapper());
    }

    public HttpPostEmitter(HttpEmitterConfig config, AsyncHttpClient client, ObjectMapper jsonMapper) {
        this.batchingStrategy = config.getBatchingStrategy();
        int batchOverhead = this.batchingStrategy.batchStartLength() + this.batchingStrategy.batchEndLength();
        Preconditions.checkArgument((config.getMaxBatchSize() >= 1047552 + batchOverhead ? 1 : 0) != 0, (Object)StringUtils.format("maxBatchSize must be greater than MAX_EVENT_SIZE[%,d] + overhead[%,d].", 1047552, batchOverhead));
        this.config = config;
        this.bufferSize = config.getMaxBatchSize();
        this.maxBufferWatermark = this.bufferSize - this.batchingStrategy.batchEndLength();
        this.largeEventThreshold = (this.bufferSize - batchOverhead - this.batchingStrategy.separatorLength()) / 2;
        this.client = client;
        this.jsonMapper = jsonMapper;
        try {
            this.url = new URL(config.getRecipientBaseUrl()).toString();
        }
        catch (MalformedURLException e) {
            throw new ISE(e, "Bad URL: %s", config.getRecipientBaseUrl());
        }
        this.emittingThread = new EmittingThread(config);
        long firstBatchNumber = 1L;
        this.concurrentBatch.set(new Batch(this, this.acquireBuffer(), firstBatchNumber));
        this.lastBatchFillTimeMillis = Math.max(config.minHttpTimeoutMillis, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStart
    public void start() {
        Object object = this.startLock;
        synchronized (object) {
            if (!this.running) {
                if (this.startLatch.getCount() == 0L) {
                    throw new IllegalStateException("Already started.");
                }
                this.running = true;
                this.startLatch.countDown();
                this.emittingThread.start();
            }
        }
    }

    private void awaitStarted() {
        try {
            if (!this.startLatch.await(1L, TimeUnit.SECONDS)) {
                throw new RejectedExecutionException("Service is not started.");
            }
            if (this.isTerminated()) {
                throw new RejectedExecutionException("Service is closed.");
            }
        }
        catch (InterruptedException e) {
            log.debug("Interrupted waiting for start", new Object[0]);
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private boolean isTerminated() {
        return this.concurrentBatch.get() == null;
    }

    @Override
    public void emit(Event event) {
        this.emitAndReturnBatch(event);
    }

    @Nullable
    @VisibleForTesting
    Batch emitAndReturnBatch(Event event) {
        this.awaitStarted();
        byte[] eventBytes = this.eventToBytes(event);
        if (eventBytes.length > 1047552) {
            log.error("Event too large to emit (%,d > %,d): %s ...", eventBytes.length, 1047552, StringUtils.fromUtf8(ByteBuffer.wrap(eventBytes), 1024));
            return null;
        }
        if (eventBytes.length > this.largeEventThreshold) {
            this.writeLargeEvent(eventBytes);
            return null;
        }
        while (true) {
            Object batchObj;
            if ((batchObj = this.concurrentBatch.get()) instanceof Integer) {
                this.tryRecoverCurrentBatch((Integer)batchObj);
                continue;
            }
            if (batchObj == null) {
                throw new RejectedExecutionException("Service is closed.");
            }
            Batch batch = (Batch)batchObj;
            if (batch.tryAddEvent(eventBytes)) {
                return batch;
            }
            log.debug("Failed to emit an event in batch [%s]", batch);
        }
    }

    private byte[] eventToBytes(Event event) {
        try {
            return this.jsonMapper.writeValueAsBytes((Object)event);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeLargeEvent(byte[] eventBytes) {
        if (this.approximateBuffersToEmitCount.get() > this.config.getBatchQueueSizeLimit()) {
            log.error("largeEventsToEmit queue size reached the limit [%d], dropping the latest large event", this.config.getBatchQueueSizeLimit());
        } else {
            this.largeEventsToEmit.add(eventBytes);
            this.approximateBuffersToEmitCount.incrementAndGet();
            this.approximateLargeEventsToEmitCount.incrementAndGet();
            this.approximateEventsToEmitCount.incrementAndGet();
        }
        this.wakeUpEmittingThread();
    }

    void onSealExclusive(Batch batch, long elapsedTimeMillis) {
        try {
            this.doOnSealExclusive(batch, elapsedTimeMillis);
        }
        catch (Throwable t) {
            try {
                if (!this.concurrentBatch.compareAndSet(batch, batch.batchNumber)) {
                    log.error("Unexpected failure to set currentBatch to the failed Batch.batchNumber", new Object[0]);
                }
                log.error(t, "Serious error during onSealExclusive(), set currentBatch to the failed Batch.batchNumber", new Object[0]);
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }
    }

    private void doOnSealExclusive(Batch batch, long elapsedTimeMillis) {
        this.batchFillingTimeCounter.add((int)Math.max(elapsedTimeMillis, 0L));
        if (elapsedTimeMillis > 0L) {
            this.lastBatchFillTimeMillis = elapsedTimeMillis;
        }
        this.addBatchToEmitQueue(batch);
        this.wakeUpEmittingThread();
        if (!this.isTerminated()) {
            long nextBatchNumber = ConcurrentAwaitableCounter.nextCount(batch.batchNumber);
            byte[] newBuffer = this.acquireBuffer();
            if (!this.concurrentBatch.compareAndSet(batch, new Batch(this, newBuffer, nextBatchNumber))) {
                this.buffersToReuse.add(newBuffer);
                Preconditions.checkState((boolean)this.isTerminated());
            }
        }
    }

    private void tryRecoverCurrentBatch(Integer failedBatchNumber) {
        log.info("Trying to recover currentBatch", new Object[0]);
        long nextBatchNumber = ConcurrentAwaitableCounter.nextCount(failedBatchNumber.intValue());
        byte[] newBuffer = this.acquireBuffer();
        if (this.concurrentBatch.compareAndSet(failedBatchNumber, new Batch(this, newBuffer, nextBatchNumber))) {
            log.info("Successfully recovered currentBatch", new Object[0]);
        } else {
            this.buffersToReuse.add(newBuffer);
        }
    }

    private void addBatchToEmitQueue(Batch batch) {
        this.limitBuffersToEmitSize();
        this.buffersToEmit.addLast(batch);
        this.approximateBuffersToEmitCount.incrementAndGet();
        this.approximateEventsToEmitCount.addAndGet(batch.eventCount.get());
    }

    private void limitBuffersToEmitSize() {
        Batch droppedBatch;
        if (this.approximateBuffersToEmitCount.get() >= this.config.getBatchQueueSizeLimit() && (droppedBatch = this.buffersToEmit.pollFirst()) != null) {
            this.batchFinalized();
            this.approximateBuffersToEmitCount.decrementAndGet();
            this.approximateEventsToEmitCount.addAndGet(-droppedBatch.eventCount.get());
            this.droppedBuffers.incrementAndGet();
            log.error("buffersToEmit queue size reached the limit [%d], dropping the oldest buffer to emit", this.config.getBatchQueueSizeLimit());
        }
    }

    private void batchFinalized() {
        this.emittedBatchCounter.increment();
    }

    private Batch pollBatchFromEmitQueue() {
        Batch result = this.buffersToEmit.pollFirst();
        if (result == null) {
            return null;
        }
        this.approximateBuffersToEmitCount.decrementAndGet();
        this.approximateEventsToEmitCount.addAndGet(-result.eventCount.get());
        return result;
    }

    private void wakeUpEmittingThread() {
        LockSupport.unpark(this.emittingThread);
    }

    @Override
    public void flush() throws IOException {
        this.awaitStarted();
        Object batchObj = this.concurrentBatch.get();
        if (batchObj instanceof Batch) {
            this.flush((Batch)batchObj);
        }
    }

    private void flush(Batch batch) throws IOException {
        if (batch == null) {
            return;
        }
        batch.seal();
        try {
            this.emittedBatchCounter.awaitCount(batch.batchNumber, this.config.getFlushTimeOut(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            String message = StringUtils.format("Timed out after [%d] millis during flushing", this.config.getFlushTimeOut());
            throw new IOException(message, e);
        }
        catch (InterruptedException e) {
            log.debug("Thread Interrupted", new Object[0]);
            Thread.currentThread().interrupt();
            throw new IOException("Thread Interrupted while flushing", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStop
    public void close() throws IOException {
        Object object = this.startLock;
        synchronized (object) {
            if (this.running) {
                this.running = false;
                Object lastBatch = this.concurrentBatch.getAndSet(null);
                if (lastBatch instanceof Batch) {
                    this.flush(lastBatch);
                }
                this.emittingThread.shuttingDown = true;
                this.emittingThread.interrupt();
            }
        }
    }

    public String toString() {
        return "HttpPostEmitter{config=" + this.config + '}';
    }

    private byte[] acquireBuffer() {
        byte[] buffer = this.buffersToReuse.poll();
        if (buffer == null) {
            buffer = new byte[this.bufferSize];
            this.allocatedBuffers.incrementAndGet();
        } else {
            this.approximateBuffersToReuseCount.decrementAndGet();
        }
        return buffer;
    }

    private void drainBuffersToReuse() {
        while (this.buffersToReuse.poll() != null) {
            this.approximateBuffersToReuseCount.decrementAndGet();
        }
    }

    public int getTotalAllocatedBuffers() {
        return this.allocatedBuffers.get();
    }

    public int getBuffersToEmit() {
        return this.approximateBuffersToEmitCount.get();
    }

    public int getBuffersToReuse() {
        return this.approximateBuffersToReuseCount.get();
    }

    public int getTotalFailedBuffers() {
        return this.emittingThread.approximateFailedBuffersCount.get();
    }

    public int getTotalDroppedBuffers() {
        return this.droppedBuffers.get();
    }

    public long getTotalEmittedEvents() {
        return this.totalEmittedEvents.get();
    }

    public long getEventsToEmit() {
        return this.approximateEventsToEmitCount.get();
    }

    public long getLargeEventsToEmit() {
        return this.approximateLargeEventsToEmitCount.get();
    }

    public ConcurrentTimeCounter getBatchFillingTimeCounter() {
        return this.batchFillingTimeCounter;
    }

    public ConcurrentTimeCounter getSuccessfulSendingTimeCounter() {
        return this.emittingThread.successfulSendingTimeCounter;
    }

    public ConcurrentTimeCounter getFailedSendingTimeCounter() {
        return this.emittingThread.failedSendingTimeCounter;
    }

    @VisibleForTesting
    void waitForEmission(int batchNumber) throws Exception {
        this.emittedBatchCounter.awaitCount(batchNumber, 10L, TimeUnit.SECONDS);
    }

    @VisibleForTesting
    void joinEmitterThread() throws InterruptedException {
        this.emittingThread.join();
    }

    private static class FailedBuffer {
        final byte[] buffer;
        final int length;
        final int eventCount;

        private FailedBuffer(byte[] buffer, int length, int eventCount) {
            this.buffer = buffer;
            this.length = length;
            this.eventCount = eventCount;
        }
    }

    private class EmittingThread
    extends Thread {
        private final ArrayDeque<FailedBuffer> failedBuffers;
        private final AtomicInteger approximateFailedBuffersCount;
        private final ConcurrentTimeCounter successfulSendingTimeCounter;
        private final ConcurrentTimeCounter failedSendingTimeCounter;
        private final TimeoutException timeoutLessThanMinimumException;
        private boolean shuttingDown;
        private ZeroCopyByteArrayOutputStream gzipBaos;

        EmittingThread(HttpEmitterConfig config) {
            super("HttpPostEmitter-" + instanceCounter.incrementAndGet());
            this.failedBuffers = new ArrayDeque();
            this.approximateFailedBuffersCount = new AtomicInteger();
            this.successfulSendingTimeCounter = new ConcurrentTimeCounter();
            this.failedSendingTimeCounter = new ConcurrentTimeCounter();
            this.shuttingDown = false;
            this.setDaemon(true);
            this.timeoutLessThanMinimumException = new TimeoutException("Timeout less than minimum [" + config.getMinHttpTimeoutMillis() + "] ms.");
            this.timeoutLessThanMinimumException.setStackTrace(new StackTraceElement[0]);
        }

        @Override
        public void run() {
            while (true) {
                boolean needsToShutdown = this.needsToShutdown();
                try {
                    this.emitLargeEvents();
                    this.emitBatches();
                    this.tryEmitOneFailedBuffer();
                    if (needsToShutdown) {
                        this.tryEmitAndDrainAllFailedBuffers();
                        HttpPostEmitter.this.drainBuffersToReuse();
                        return;
                    }
                }
                catch (Throwable t) {
                    log.error(t, "Uncaught exception in EmittingThread.run()", new Object[0]);
                }
                if (!this.failedBuffers.isEmpty()) continue;
                long waitNanos = Math.max(TimeUnit.MILLISECONDS.toNanos(HttpPostEmitter.this.config.getFlushMillis()) / 2L, 1L);
                LockSupport.parkNanos(HttpPostEmitter.this, waitNanos);
            }
        }

        private boolean needsToShutdown() {
            boolean needsToShutdown;
            boolean bl = needsToShutdown = Thread.interrupted() || this.shuttingDown;
            if (needsToShutdown) {
                Object lastBatch = HttpPostEmitter.this.concurrentBatch.getAndSet(null);
                if (lastBatch instanceof Batch) {
                    ((Batch)lastBatch).seal();
                }
            } else {
                Object batch = HttpPostEmitter.this.concurrentBatch.get();
                if (batch instanceof Batch) {
                    ((Batch)batch).sealIfFlushNeeded();
                } else {
                    needsToShutdown = batch == null;
                }
            }
            return needsToShutdown;
        }

        private void emitBatches() {
            Batch batch;
            while ((batch = HttpPostEmitter.this.pollBatchFromEmitQueue()) != null) {
                this.emit(batch);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void emit(Batch batch) {
            batch.awaitEmittingAllowed();
            try {
                int bufferWatermark = batch.getSealedBufferWatermark();
                if (bufferWatermark == 0) {
                    return;
                }
                int eventCount = batch.eventCount.get();
                log.debug("Sending batch #%d to url[%s], event count[%d], bytes[%d]", batch.batchNumber, HttpPostEmitter.this.url, eventCount, bufferWatermark);
                int bufferEndOffset = HttpPostEmitter.this.batchingStrategy.writeBatchEnd(batch.buffer, bufferWatermark);
                if (this.sendWithRetries(batch.buffer, bufferEndOffset, eventCount, true)) {
                    HttpPostEmitter.this.buffersToReuse.add(batch.buffer);
                    HttpPostEmitter.this.approximateBuffersToReuseCount.incrementAndGet();
                } else {
                    this.limitFailedBuffersSize();
                    this.failedBuffers.addLast(new FailedBuffer(batch.buffer, bufferEndOffset, eventCount));
                    this.approximateFailedBuffersCount.incrementAndGet();
                }
            }
            finally {
                HttpPostEmitter.this.batchFinalized();
            }
        }

        private void limitFailedBuffersSize() {
            if (this.failedBuffers.size() >= HttpPostEmitter.this.config.getBatchQueueSizeLimit()) {
                this.failedBuffers.removeFirst();
                this.approximateFailedBuffersCount.decrementAndGet();
                HttpPostEmitter.this.droppedBuffers.incrementAndGet();
                log.error("failedBuffers queue size reached the limit [%d], dropping the oldest failed buffer", HttpPostEmitter.this.config.getBatchQueueSizeLimit());
            }
        }

        private void emitLargeEvents() {
            byte[] largeEvent;
            if (HttpPostEmitter.this.largeEventsToEmit.isEmpty()) {
                return;
            }
            HttpPostEmitter.this.largeEventsToEmit.add(LARGE_EVENTS_STOP);
            while ((largeEvent = (byte[])HttpPostEmitter.this.largeEventsToEmit.poll()) != LARGE_EVENTS_STOP) {
                this.emitLargeEvent(largeEvent);
                HttpPostEmitter.this.approximateBuffersToEmitCount.decrementAndGet();
                HttpPostEmitter.this.approximateLargeEventsToEmitCount.decrementAndGet();
                HttpPostEmitter.this.approximateEventsToEmitCount.decrementAndGet();
            }
        }

        private void emitLargeEvent(byte[] eventBytes) {
            byte[] buffer = HttpPostEmitter.this.acquireBuffer();
            int bufferOffset = HttpPostEmitter.this.batchingStrategy.writeBatchStart(buffer);
            System.arraycopy(eventBytes, 0, buffer, bufferOffset, eventBytes.length);
            bufferOffset += eventBytes.length;
            bufferOffset = HttpPostEmitter.this.batchingStrategy.writeBatchEnd(buffer, bufferOffset);
            if (this.sendWithRetries(buffer, bufferOffset, 1, true)) {
                HttpPostEmitter.this.buffersToReuse.add(buffer);
                HttpPostEmitter.this.approximateBuffersToReuseCount.incrementAndGet();
            } else {
                this.limitFailedBuffersSize();
                this.failedBuffers.addLast(new FailedBuffer(buffer, bufferOffset, 1));
                this.approximateFailedBuffersCount.incrementAndGet();
            }
        }

        private void tryEmitOneFailedBuffer() {
            FailedBuffer failedBuffer = this.failedBuffers.peekFirst();
            if (failedBuffer != null && this.sendWithRetries(failedBuffer.buffer, failedBuffer.length, failedBuffer.eventCount, false)) {
                this.failedBuffers.pollFirst();
                this.approximateFailedBuffersCount.decrementAndGet();
            }
        }

        private void tryEmitAndDrainAllFailedBuffers() {
            FailedBuffer failedBuffer;
            while ((failedBuffer = this.failedBuffers.pollFirst()) != null) {
                this.sendWithRetries(failedBuffer.buffer, failedBuffer.length, failedBuffer.eventCount, false);
                this.approximateFailedBuffersCount.decrementAndGet();
            }
        }

        private boolean sendWithRetries(final byte[] buffer, final int length, int eventCount, final boolean withTimeout) {
            final long deadLineMillis = System.currentTimeMillis() + this.computeTimeoutForSendRequestInMillis(HttpPostEmitter.this.lastBatchFillTimeMillis);
            try {
                RetryUtils.retry(new RetryUtils.Task<Object>(){

                    @Override
                    public Void perform() throws Exception {
                        EmittingThread.this.send(buffer, length);
                        return null;
                    }
                }, new Predicate<Throwable>(){

                    public boolean apply(Throwable e) {
                        if (withTimeout && deadLineMillis - System.currentTimeMillis() <= 0L) {
                            return false;
                        }
                        if (e == EmittingThread.this.timeoutLessThanMinimumException) {
                            return false;
                        }
                        return !(e instanceof InterruptedException);
                    }
                }, 3);
                HttpPostEmitter.this.totalEmittedEvents.addAndGet(eventCount);
                return true;
            }
            catch (InterruptedException e) {
                return false;
            }
            catch (Exception e) {
                if (e == this.timeoutLessThanMinimumException) {
                    log.debug(e, "Failed to send events to url[%s] with timeout less than minimum", HttpPostEmitter.this.config.getRecipientBaseUrl());
                } else {
                    log.error(e, "Failed to send events to url[%s]", HttpPostEmitter.this.config.getRecipientBaseUrl());
                }
                return false;
            }
        }

        private void send(byte[] buffer, int length) throws Exception {
            Response response;
            int payloadLength;
            byte[] payload;
            RequestBuilder request;
            long sendingStartMs;
            long timeoutMillis;
            long lastFillTimeMillis;
            block23: {
                block22: {
                    lastFillTimeMillis = HttpPostEmitter.this.lastBatchFillTimeMillis;
                    timeoutMillis = this.computeTimeoutForSendRequestInMillis(lastFillTimeMillis);
                    if (timeoutMillis < (long)HttpPostEmitter.this.config.getMinHttpTimeoutMillis()) {
                        throw this.timeoutLessThanMinimumException;
                    }
                    sendingStartMs = System.currentTimeMillis();
                    request = new RequestBuilder("POST");
                    request.setUrl(HttpPostEmitter.this.url);
                    ContentEncoding contentEncoding = HttpPostEmitter.this.config.getContentEncoding();
                    if (contentEncoding == null) break block22;
                    switch (contentEncoding) {
                        case GZIP: {
                            try (GZIPOutputStream gzipOutputStream = this.acquireGzipOutputStream(length);){
                                gzipOutputStream.write(buffer, 0, length);
                            }
                            payload = this.gzipBaos.getBuffer();
                            payloadLength = this.gzipBaos.size();
                            request.setHeader((CharSequence)"Content-Encoding", "gzip");
                            break block23;
                        }
                        default: {
                            throw new ISE("Unsupported content encoding [%s]", contentEncoding.name());
                        }
                    }
                }
                payload = buffer;
                payloadLength = length;
            }
            request.setHeader((CharSequence)"Content-Type", "application/json");
            request.setHeader((CharSequence)"Content-Length", String.valueOf(payloadLength));
            request.setBody(ByteBuffer.wrap(payload, 0, payloadLength));
            if (HttpPostEmitter.this.config.getBasicAuthentication() != null) {
                String[] parts = HttpPostEmitter.this.config.getBasicAuthentication().split(":", 2);
                String user = parts[0];
                String password = parts.length > 1 ? parts[1] : "";
                String encoded = StringUtils.encodeBase64String((user + ':' + password).getBytes(StandardCharsets.UTF_8));
                request.setHeader((CharSequence)"Authorization", "Basic " + encoded);
            }
            request.setRequestTimeout(Ints.saturatedCast((long)timeoutMillis));
            ListenableFuture future = HttpPostEmitter.this.client.executeRequest(request);
            try {
                response = (Response)future.get();
            }
            catch (ExecutionException e) {
                this.accountFailedSending(sendingStartMs);
                if (e.getCause() instanceof TimeoutException) {
                    log.error("Timing out emitter batch send, last batch fill time [%,d] ms, timeout [%,d] ms", lastFillTimeMillis, timeoutMillis);
                }
                throw e;
            }
            if (response.getStatusCode() == 413) {
                this.accountFailedSending(sendingStartMs);
                throw new ISE("Received HTTP status 413 from [%s]. Batch size of [%d] may be too large, try adjusting maxBatchSizeBatch property", HttpPostEmitter.this.config.getRecipientBaseUrl(), HttpPostEmitter.this.config.getMaxBatchSize());
            }
            if (response.getStatusCode() / 100 != 2) {
                this.accountFailedSending(sendingStartMs);
                throw new ISE("Emissions of events not successful[%d: %s], with message[%s].", response.getStatusCode(), response.getStatusText(), response.getResponseBody(StandardCharsets.UTF_8).trim());
            }
            this.accountSuccessfulSending(sendingStartMs);
        }

        private long computeTimeoutForSendRequestInMillis(long lastBatchFillTimeMillis) {
            int emitQueueSize = HttpPostEmitter.this.approximateBuffersToEmitCount.get();
            if (emitQueueSize < 5) {
                return (long)((float)lastBatchFillTimeMillis * HttpPostEmitter.this.config.httpTimeoutAllowanceFactor);
            }
            if (emitQueueSize < 10) {
                return (long)((double)lastBatchFillTimeMillis * 0.9);
            }
            return (long)((double)lastBatchFillTimeMillis * 0.5);
        }

        private void accountSuccessfulSending(long sendingStartMs) {
            this.successfulSendingTimeCounter.add((int)Math.max(System.currentTimeMillis() - sendingStartMs, 0L));
        }

        private void accountFailedSending(long sendingStartMs) {
            this.failedSendingTimeCounter.add((int)Math.max(System.currentTimeMillis() - sendingStartMs, 0L));
        }

        GZIPOutputStream acquireGzipOutputStream(int length) throws IOException {
            if (this.gzipBaos == null) {
                this.gzipBaos = new ZeroCopyByteArrayOutputStream(length);
            } else {
                this.gzipBaos.reset();
            }
            return new GZIPOutputStream((OutputStream)this.gzipBaos, true);
        }
    }
}

