/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.parsers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.concurrent.TimeUnit;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.parsers.ParserUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.ISODateTimeFormat;

public class TimestampParser {
    public static Function<String, DateTime> createTimestampParser(String format) {
        if ("auto".equalsIgnoreCase(format)) {
            DateTimes.UtcFormatter parser = DateTimes.wrapFormatter(TimestampParser.createAutoParser());
            return input -> {
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)input) ? 1 : 0) != 0, (Object)"null timestamp");
                for (int i = 0; i < input.length(); ++i) {
                    DateTimeZone timeZoneFromString;
                    if (input.charAt(i) >= '0' && input.charAt(i) <= '9') continue;
                    input = ParserUtils.stripQuotes(input);
                    int lastIndex = input.lastIndexOf(32);
                    DateTimeZone timeZone = DateTimeZone.UTC;
                    if (lastIndex > 0 && (timeZoneFromString = ParserUtils.getDateTimeZone(input.substring(lastIndex + 1))) != null) {
                        timeZone = timeZoneFromString;
                        input = input.substring(0, lastIndex);
                    }
                    return parser.parse((String)input).withZone(timeZone);
                }
                return DateTimes.utc(Long.parseLong(input));
            };
        }
        if ("iso".equalsIgnoreCase(format)) {
            return input -> {
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)input) ? 1 : 0) != 0, (Object)"null timestamp");
                return DateTimes.of(ParserUtils.stripQuotes(input));
            };
        }
        if ("posix".equalsIgnoreCase(format) || "millis".equalsIgnoreCase(format) || "micro".equalsIgnoreCase(format) || "nano".equalsIgnoreCase(format)) {
            Function<Number, DateTime> numericFun = TimestampParser.createNumericTimestampParser(format);
            return input -> {
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)input) ? 1 : 0) != 0, (Object)"null timestamp");
                return (DateTime)numericFun.apply((Object)Long.parseLong(ParserUtils.stripQuotes(input)));
            };
        }
        if ("ruby".equalsIgnoreCase(format)) {
            Function<Number, DateTime> numericFun = TimestampParser.createNumericTimestampParser(format);
            return input -> {
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)input) ? 1 : 0) != 0, (Object)"null timestamp");
                return (DateTime)numericFun.apply((Object)Double.parseDouble(ParserUtils.stripQuotes(input)));
            };
        }
        try {
            DateTimes.UtcFormatter formatter = DateTimes.wrapFormatter(DateTimeFormat.forPattern((String)format));
            return input -> {
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)input) ? 1 : 0) != 0, (Object)"null timestamp");
                return formatter.parse(ParserUtils.stripQuotes(input));
            };
        }
        catch (Exception e) {
            throw new IAE(e, "Unable to parse timestamps with format [%s]", format);
        }
    }

    public static Function<Number, DateTime> createNumericTimestampParser(String format) {
        if ("posix".equalsIgnoreCase(format)) {
            return input -> DateTimes.utc(TimeUnit.SECONDS.toMillis(input.longValue()));
        }
        if ("micro".equalsIgnoreCase(format)) {
            return input -> DateTimes.utc(TimeUnit.MICROSECONDS.toMillis(input.longValue()));
        }
        if ("nano".equalsIgnoreCase(format)) {
            return input -> DateTimes.utc(TimeUnit.NANOSECONDS.toMillis(input.longValue()));
        }
        if ("ruby".equalsIgnoreCase(format)) {
            return input -> DateTimes.utc(Double.valueOf(input.doubleValue() * 1000.0).longValue());
        }
        return input -> DateTimes.utc(input.longValue());
    }

    public static Function<Object, DateTime> createObjectTimestampParser(String format) {
        Function<String, DateTime> stringFun = TimestampParser.createTimestampParser(format);
        Function<Number, DateTime> numericFun = TimestampParser.createNumericTimestampParser(format);
        return o -> {
            Preconditions.checkNotNull((Object)o, (Object)"null timestamp");
            if (o instanceof Number) {
                return (DateTime)numericFun.apply((Object)((Number)o));
            }
            return (DateTime)stringFun.apply((Object)o.toString());
        };
    }

    private static DateTimeFormatter createAutoParser() {
        DateTimeFormatter offsetElement = new DateTimeFormatterBuilder().appendTimeZoneOffset("Z", true, 2, 4).toFormatter();
        DateTimeParser timeOrOffset = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{new DateTimeFormatterBuilder().appendLiteral('T').toParser(), new DateTimeFormatterBuilder().appendLiteral(' ').toParser()}).appendOptional(ISODateTimeFormat.timeElementParser().getParser()).appendOptional(offsetElement.getParser()).toParser();
        return new DateTimeFormatterBuilder().append(ISODateTimeFormat.dateElementParser()).appendOptional(timeOrOffset).toFormatter();
    }
}

