/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.parsers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.parsers.AbstractFlatTextFormatParser;

public class DelimitedParser
extends AbstractFlatTextFormatParser {
    private final String delimiter;
    private final Splitter splitter;

    public DelimitedParser(@Nullable String delimiter, @Nullable String listDelimiter, boolean hasHeaderRow, int maxSkipHeaderRows) {
        super(listDelimiter, hasHeaderRow, maxSkipHeaderRows);
        this.delimiter = delimiter != null ? delimiter : AbstractFlatTextFormatParser.FlatTextFormat.DELIMITED.getDefaultDelimiter();
        Preconditions.checkState((!this.delimiter.equals(this.getListDelimiter()) ? 1 : 0) != 0, (String)"Cannot have same delimiter and list delimiter of [%s]", (Object[])new Object[]{this.delimiter});
        this.splitter = Splitter.on((String)this.delimiter);
    }

    public DelimitedParser(@Nullable String delimiter, @Nullable String listDelimiter, Iterable<String> fieldNames, boolean hasHeaderRow, int maxSkipHeaderRows) {
        this(delimiter, listDelimiter, hasHeaderRow, maxSkipHeaderRows);
        this.setFieldNames(fieldNames);
    }

    @VisibleForTesting
    DelimitedParser(@Nullable String delimiter, @Nullable String listDelimiter, String header) {
        this(delimiter, listDelimiter, false, 0);
        this.setFieldNames(header);
    }

    @Override
    protected List<String> parseLine(String input) {
        return this.splitToList(input);
    }

    private List<String> splitToList(String input) {
        Preconditions.checkNotNull((Object)input);
        Iterator iterator = this.splitter.split((CharSequence)input).iterator();
        ArrayList result = new ArrayList();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return Collections.unmodifiableList(result);
    }
}

