/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.guava;

import com.google.common.collect.Ordering;
import java.io.Closeable;
import java.io.IOException;
import java.util.PriorityQueue;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.druid.java.util.common.guava.YieldingSequenceBase;
import org.apache.druid.java.util.common.io.Closer;

public class MergeSequence<T>
extends YieldingSequenceBase<T> {
    private final Ordering<? super T> ordering;
    private final Sequence<? extends Sequence<T>> baseSequences;

    public MergeSequence(Ordering<? super T> ordering, Sequence<? extends Sequence<? extends T>> baseSequences) {
        this.ordering = ordering;
        this.baseSequences = baseSequences;
    }

    @Override
    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
        PriorityQueue pQueue = new PriorityQueue(32, this.ordering.onResultOf(input -> input.get()));
        pQueue = this.baseSequences.accumulate(pQueue, (queue, in) -> {
            Yielder<Object> yielder = in.toYielder(null, new YieldingAccumulator<T, T>(){

                @Override
                public T accumulate(T accumulated, T in) {
                    this.yield();
                    return in;
                }
            });
            if (!yielder.isDone()) {
                queue.add(yielder);
            } else {
                try {
                    yielder.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return queue;
        });
        return this.makeYielder(pQueue, initValue, accumulator);
    }

    private <OutType> Yielder<OutType> makeYielder(final PriorityQueue<Yielder<T>> pQueue, OutType initVal, final YieldingAccumulator<OutType, T> accumulator) {
        OutType retVal = initVal;
        while (!accumulator.yielded() && !pQueue.isEmpty()) {
            Yielder<Object> yielder = (Yielder<Object>)pQueue.remove();
            retVal = accumulator.accumulate(retVal, yielder.get());
            if ((yielder = yielder.next(null)).isDone()) {
                try {
                    yielder.close();
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            pQueue.add(yielder);
        }
        if (pQueue.isEmpty() && !accumulator.yielded()) {
            return Yielders.done(retVal, null);
        }
        final OutType yieldVal = retVal;
        return new Yielder<OutType>(){

            @Override
            public OutType get() {
                return yieldVal;
            }

            @Override
            public Yielder<OutType> next(OutType initValue) {
                accumulator.reset();
                return MergeSequence.this.makeYielder(pQueue, initValue, accumulator);
            }

            @Override
            public boolean isDone() {
                return false;
            }

            @Override
            public void close() throws IOException {
                Closer closer = Closer.create();
                while (!pQueue.isEmpty()) {
                    closer.register((Closeable)pQueue.remove());
                }
                closer.close();
            }
        };
    }
}

