/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import java.io.Closeable;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import org.apache.druid.java.util.common.MappedByteBufferHandler;
import org.apache.druid.java.util.common.StreamUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;

public class FileUtils {
    private static final Logger log = new Logger(FileUtils.class);
    public static final Predicate<Throwable> IS_EXCEPTION = new Predicate<Throwable>(){

        public boolean apply(Throwable input) {
            return input instanceof Exception;
        }
    };

    public static FileCopyResult retryCopy(ByteSource byteSource, File outFile, Predicate<Throwable> shouldRetry, int maxAttempts) {
        try {
            StreamUtils.retryCopy(byteSource, com.google.common.io.Files.asByteSink((File)outFile, (FileWriteMode[])new FileWriteMode[0]), shouldRetry, maxAttempts);
            return new FileCopyResult(outFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static MappedByteBufferHandler map(File file) throws IOException {
        MappedByteBuffer mappedByteBuffer = com.google.common.io.Files.map((File)file);
        return new MappedByteBufferHandler(mappedByteBuffer);
    }

    public static <T> T writeAtomically(File file, OutputStreamConsumer<T> f) throws IOException {
        return FileUtils.writeAtomically(file, file.getParentFile(), f);
    }

    private static <T> T writeAtomically(File file, File tmpDir, OutputStreamConsumer<T> f) throws IOException {
        File tmpFile = new File(tmpDir, StringUtils.format(".%s.%s", file.getName(), UUID.randomUUID()));
        try (Closeable deleter = () -> Files.deleteIfExists(tmpFile.toPath());){
            T retVal;
            try (FileChannel fileChannel = FileChannel.open(tmpFile.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
                 OutputStream out = Channels.newOutputStream(fileChannel);){
                retVal = f.apply(FileUtils.uncloseable(out));
                fileChannel.force(true);
            }
            Files.move(tmpFile.toPath(), file.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            var8_7 = null;
            try (FileChannel directory = FileChannel.open(file.getParentFile().toPath(), StandardOpenOption.READ);){
                directory.force(true);
            }
            catch (Throwable throwable) {
                var8_7 = throwable;
                throw throwable;
            }
            T t = retVal;
            return t;
        }
    }

    private static OutputStream uncloseable(OutputStream out) {
        return new FilterOutputStream(out){

            @Override
            public void close() {
            }
        };
    }

    public static interface OutputStreamConsumer<T> {
        public T apply(OutputStream var1) throws IOException;
    }

    public static class FileCopyResult {
        private final Collection<File> files = new ArrayList<File>();
        private long size = 0L;

        public Collection<File> getFiles() {
            return ImmutableList.copyOf(this.files);
        }

        public long size() {
            return this.size;
        }

        public FileCopyResult(File ... files) {
            this((Collection<File>)(files == null ? ImmutableList.of() : Arrays.asList(files)));
        }

        public FileCopyResult(Collection<File> files) {
            this.addSizedFiles(files);
        }

        protected void addSizedFiles(Collection<File> files) {
            if (files == null || files.isEmpty()) {
                return;
            }
            long size = 0L;
            for (File file : files) {
                size += file.length();
            }
            this.files.addAll(files);
            this.size += size;
        }

        public void addFiles(Collection<File> files) {
            this.addSizedFiles(files);
        }

        public void addFile(File file) {
            this.addFiles((Collection<File>)ImmutableList.of((Object)file));
        }
    }
}

