/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl.prefetch;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.io.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import org.apache.druid.data.input.impl.prefetch.ObjectOpenFunction;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.logger.Logger;

class RetryingInputStream<T>
extends InputStream {
    private static final Logger log = new Logger(RetryingInputStream.class);
    private final T object;
    private final ObjectOpenFunction<T> objectOpenFunction;
    private final Predicate<Throwable> retryCondition;
    private final int maxRetry;
    private CountingInputStream delegate;
    private long startOffset;

    RetryingInputStream(T object, ObjectOpenFunction<T> objectOpenFunction, Predicate<Throwable> retryCondition, int maxRetry) throws IOException {
        this.object = object;
        this.objectOpenFunction = objectOpenFunction;
        this.retryCondition = retryCondition;
        this.maxRetry = maxRetry;
        this.delegate = new CountingInputStream(objectOpenFunction.open(object));
    }

    private boolean isConnectionReset(Throwable t) {
        return t instanceof SocketException && t.getMessage() != null && t.getMessage().contains("Connection reset") || t.getCause() != null && this.isConnectionReset(t.getCause());
    }

    private void waitOrThrow(Throwable t, int nTry) throws IOException {
        boolean isConnectionReset = this.isConnectionReset(t);
        if (isConnectionReset || this.retryCondition.apply((Object)t)) {
            if (isConnectionReset) {
                this.startOffset += this.delegate.getCount();
                try {
                    this.delegate.close();
                }
                catch (IOException e) {
                    log.warn(e, "Error while closing the delegate input stream", new Object[0]);
                }
            }
            try {
                RetryUtils.awaitNextRetry(t, null, nTry + 1, this.maxRetry, false);
                if (isConnectionReset) {
                    log.info("retrying from offset[%d]", this.startOffset);
                    this.delegate = new CountingInputStream(this.objectOpenFunction.open(this.object, this.startOffset));
                }
            }
            catch (IOException | InterruptedException e) {
                t.addSuppressed(e);
                RetryingInputStream.throwAsIOException(t);
            }
        } else {
            RetryingInputStream.throwAsIOException(t);
        }
    }

    private static void throwAsIOException(Throwable t) throws IOException {
        Throwables.propagateIfInstanceOf((Throwable)t, IOException.class);
        throw new IOException(t);
    }

    @Override
    public int read() throws IOException {
        for (int nTry = 0; nTry < this.maxRetry; ++nTry) {
            try {
                return this.delegate.read();
            }
            catch (Throwable t) {
                this.waitOrThrow(t, nTry);
                continue;
            }
        }
        return this.delegate.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        for (int nTry = 0; nTry < this.maxRetry; ++nTry) {
            try {
                return this.delegate.read(b);
            }
            catch (Throwable t) {
                this.waitOrThrow(t, nTry);
                continue;
            }
        }
        return this.delegate.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        for (int nTry = 0; nTry < this.maxRetry; ++nTry) {
            try {
                return this.delegate.read(b, off, len);
            }
            catch (Throwable t) {
                this.waitOrThrow(t, nTry);
                continue;
            }
        }
        return this.delegate.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        for (int nTry = 0; nTry < this.maxRetry; ++nTry) {
            try {
                return this.delegate.skip(n);
            }
            catch (Throwable t) {
                this.waitOrThrow(t, nTry);
                continue;
            }
        }
        return this.delegate.skip(n);
    }

    @Override
    public int available() throws IOException {
        for (int nTry = 0; nTry < this.maxRetry; ++nTry) {
            try {
                return this.delegate.available();
            }
            catch (Throwable t) {
                this.waitOrThrow(t, nTry);
                continue;
            }
        }
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

