/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.commons.io.LineIterator;
import org.apache.druid.data.input.Firehose;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowPlusRaw;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.utils.Runnables;

public class FileIteratingFirehose
implements Firehose {
    private final Iterator<LineIterator> lineIterators;
    private final StringInputRowParser parser;
    private LineIterator lineIterator = null;
    private final Closeable closer;

    public FileIteratingFirehose(Iterator<LineIterator> lineIterators, StringInputRowParser parser) {
        this(lineIterators, parser, null);
    }

    public FileIteratingFirehose(Iterator<LineIterator> lineIterators, StringInputRowParser parser, Closeable closer) {
        this.lineIterators = lineIterators;
        this.parser = parser;
        this.closer = closer;
    }

    @Override
    public boolean hasMore() {
        while ((this.lineIterator == null || !this.lineIterator.hasNext()) && this.lineIterators.hasNext()) {
            this.lineIterator = this.getNextLineIterator();
        }
        return this.lineIterator != null && this.lineIterator.hasNext();
    }

    @Override
    @Nullable
    public InputRow nextRow() {
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        return this.parser.parse(this.lineIterator.next());
    }

    @Override
    public InputRowPlusRaw nextRowWithRaw() {
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        String raw = this.lineIterator.next();
        try {
            return InputRowPlusRaw.of(this.parser.parse(raw), StringUtils.toUtf8(raw));
        }
        catch (ParseException e) {
            return InputRowPlusRaw.of(StringUtils.toUtf8(raw), e);
        }
    }

    private LineIterator getNextLineIterator() {
        if (this.lineIterator != null) {
            this.lineIterator.close();
        }
        LineIterator iterator = this.lineIterators.next();
        this.parser.startFileFromBeginning();
        return iterator;
    }

    @Override
    public Runnable commit() {
        return Runnables.getNoopRunnable();
    }

    @Override
    public void close() throws IOException {
        try (Closeable ignore = this.closer;){
            Closeable ignore2 = this.lineIterator != null ? () -> ((LineIterator)this.lineIterator).close() : null;
            Throwable throwable = null;
            if (ignore2 != null) {
                if (throwable != null) {
                    try {
                        ignore2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    ignore2.close();
                }
            }
        }
    }
}

