/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.utils;

import com.google.inject.Inject;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.apache.druid.utils.RuntimeInfo;

public class JvmUtils {
    @Inject
    private static RuntimeInfo runtimeInfo = new RuntimeInfo();
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();

    public static RuntimeInfo getRuntimeInfo() {
        return runtimeInfo;
    }

    public static boolean isThreadCpuTimeEnabled() {
        return THREAD_MX_BEAN.isThreadCpuTimeSupported() && THREAD_MX_BEAN.isThreadCpuTimeEnabled();
    }

    public static long safeGetThreadCpuTime() {
        if (!JvmUtils.isThreadCpuTimeEnabled()) {
            return 0L;
        }
        return JvmUtils.getCurrentThreadCpuTime();
    }

    public static long getCurrentThreadCpuTime() {
        return THREAD_MX_BEAN.getCurrentThreadCpuTime();
    }
}

