/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import org.apache.druid.timeline.partition.PartitionChunk;

public class NumberedPartitionChunk<T>
implements PartitionChunk<T> {
    private final int chunkNumber;
    private final int chunks;
    private final T object;

    public static <T> NumberedPartitionChunk<T> make(int chunkNumber, int chunks, T obj) {
        return new NumberedPartitionChunk<T>(chunkNumber, chunks, obj);
    }

    public NumberedPartitionChunk(int chunkNumber, int chunks, T object) {
        Preconditions.checkArgument((chunkNumber >= 0 ? 1 : 0) != 0, (Object)"chunkNumber >= 0");
        Preconditions.checkArgument((chunks >= 0 ? 1 : 0) != 0, (Object)"chunks >= 0");
        this.chunkNumber = chunkNumber;
        this.chunks = chunks;
        this.object = object;
    }

    @Override
    public T getObject() {
        return this.object;
    }

    @Override
    public boolean abuts(PartitionChunk<T> other) {
        if (other instanceof NumberedPartitionChunk) {
            NumberedPartitionChunk castedOther = (NumberedPartitionChunk)other;
            if (castedOther.getChunkNumber() < castedOther.chunks) {
                return other.getChunkNumber() == this.chunkNumber + 1;
            }
            return other.getChunkNumber() > this.chunkNumber;
        }
        return false;
    }

    @Override
    public boolean isStart() {
        return this.chunks > 0 ? this.chunkNumber == 0 : true;
    }

    @Override
    public boolean isEnd() {
        return this.chunks > 0 ? this.chunkNumber == this.chunks - 1 : true;
    }

    @Override
    public int getChunkNumber() {
        return this.chunkNumber;
    }

    @Override
    public int compareTo(PartitionChunk<T> other) {
        if (other instanceof NumberedPartitionChunk) {
            NumberedPartitionChunk castedOther = (NumberedPartitionChunk)other;
            return ComparisonChain.start().compare(this.chunks, castedOther.chunks).compare(this.chunkNumber, castedOther.chunkNumber).result();
        }
        throw new IllegalArgumentException("Cannot compare against something that is not a NumberedPartitionChunk.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.compareTo((NumberedPartitionChunk)o) == 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.chunks, this.chunkNumber});
    }
}

