/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.TimelineLookup;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.partition.ImmutablePartitionHolder;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.PartitionHolder;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;

public class VersionedIntervalTimeline<VersionType, ObjectType>
implements TimelineLookup<VersionType, ObjectType> {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    final NavigableMap<Interval, TimelineEntry> completePartitionsTimeline = new TreeMap<Interval, TimelineEntry>(Comparators.intervalsByStartThenEnd());
    final NavigableMap<Interval, TimelineEntry> incompletePartitionsTimeline = new TreeMap<Interval, TimelineEntry>(Comparators.intervalsByStartThenEnd());
    private final Map<Interval, TreeMap<VersionType, TimelineEntry>> allTimelineEntries = new HashMap<Interval, TreeMap<VersionType, TimelineEntry>>();
    private final Comparator<? super VersionType> versionComparator;

    public VersionedIntervalTimeline(Comparator<? super VersionType> versionComparator) {
        this.versionComparator = versionComparator;
    }

    public static VersionedIntervalTimeline<String, DataSegment> forSegments(Iterable<DataSegment> segments) {
        return VersionedIntervalTimeline.forSegments(segments.iterator());
    }

    public static VersionedIntervalTimeline<String, DataSegment> forSegments(Iterator<DataSegment> segments) {
        VersionedIntervalTimeline<String, DataSegment> timeline = new VersionedIntervalTimeline<String, DataSegment>((Comparator<String>)Ordering.natural());
        VersionedIntervalTimeline.addSegments(timeline, segments);
        return timeline;
    }

    public static void addSegments(VersionedIntervalTimeline<String, DataSegment> timeline, Iterator<DataSegment> segments) {
        super.addAll(Iterators.transform(segments, segment -> segment.getShardSpec().createChunk(segment)), (Function<DataSegment, Interval>)((Function)DataSegment::getInterval), (Function<DataSegment, String>)((Function)DataSegment::getVersion));
    }

    @VisibleForTesting
    public Map<Interval, TreeMap<VersionType, TimelineEntry>> getAllTimelineEntries() {
        return this.allTimelineEntries;
    }

    public void add(Interval interval, VersionType version, PartitionChunk<ObjectType> object) {
        this.addAll((Iterator<PartitionChunk<ObjectType>>)Iterators.singletonIterator(object), (Function<ObjectType, Interval>)((Function)o -> interval), (Function<ObjectType, VersionType>)((Function)o -> version));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAll(Iterator<PartitionChunk<ObjectType>> objects, Function<ObjectType, Interval> intervalFunction, Function<ObjectType, VersionType> versionFunction) {
        this.lock.writeLock().lock();
        try {
            IdentityHashMap<TimelineEntry, Interval> allEntries = new IdentityHashMap<TimelineEntry, Interval>();
            while (objects.hasNext()) {
                TimelineEntry entry;
                PartitionChunk<ObjectType> object = objects.next();
                Interval interval = (Interval)intervalFunction.apply(object.getObject());
                Object version = versionFunction.apply(object.getObject());
                Map exists = this.allTimelineEntries.get(interval);
                if (exists == null) {
                    entry = new TimelineEntry(interval, version, new PartitionHolder<ObjectType>(object));
                    TreeMap<VersionType, TimelineEntry> versionEntry = new TreeMap<VersionType, TimelineEntry>(this.versionComparator);
                    versionEntry.put(version, entry);
                    this.allTimelineEntries.put(interval, versionEntry);
                } else {
                    entry = (TimelineEntry)exists.get(version);
                    if (entry == null) {
                        entry = new TimelineEntry(interval, version, new PartitionHolder<ObjectType>(object));
                        exists.put(version, entry);
                    } else {
                        PartitionHolder partitionHolder = entry.getPartitionHolder();
                        partitionHolder.add(object);
                    }
                }
                allEntries.put(entry, interval);
            }
            for (Map.Entry entry : allEntries.entrySet()) {
                Interval interval = (Interval)entry.getValue();
                if (((TimelineEntry)entry.getKey()).getPartitionHolder().isComplete()) {
                    this.add(this.completePartitionsTimeline, interval, (TimelineEntry)entry.getKey());
                }
                this.add(this.incompletePartitionsTimeline, interval, (TimelineEntry)entry.getKey());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionChunk<ObjectType> remove(Interval interval, VersionType version, PartitionChunk<ObjectType> chunk) {
        try {
            this.lock.writeLock().lock();
            Map versionEntries = this.allTimelineEntries.get(interval);
            if (versionEntries == null) {
                PartitionChunk<ObjectType> partitionChunk = null;
                return partitionChunk;
            }
            TimelineEntry entry = (TimelineEntry)versionEntries.get(version);
            if (entry == null) {
                PartitionChunk<ObjectType> partitionChunk = null;
                return partitionChunk;
            }
            PartitionChunk retVal = entry.getPartitionHolder().remove(chunk);
            if (entry.getPartitionHolder().isEmpty()) {
                versionEntries.remove(version);
                if (versionEntries.isEmpty()) {
                    this.allTimelineEntries.remove(interval);
                }
                this.remove(this.incompletePartitionsTimeline, interval, entry, true);
            }
            this.remove(this.completePartitionsTimeline, interval, entry, false);
            PartitionChunk partitionChunk = retVal;
            return partitionChunk;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionHolder<ObjectType> findEntry(Interval interval, VersionType version) {
        try {
            this.lock.readLock().lock();
            for (Map.Entry<Interval, TreeMap<VersionType, TimelineEntry>> entry : this.allTimelineEntries.entrySet()) {
                TimelineEntry foundEntry;
                if (!entry.getKey().equals((Object)interval) && !entry.getKey().contains((ReadableInterval)interval) || (foundEntry = entry.getValue().get(version)) == null) continue;
                ImmutablePartitionHolder immutablePartitionHolder = new ImmutablePartitionHolder(foundEntry.getPartitionHolder());
                return immutablePartitionHolder;
            }
            Iterator<Map.Entry<Interval, TreeMap<VersionType, TimelineEntry>>> iterator = null;
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<TimelineObjectHolder<VersionType, ObjectType>> lookup(Interval interval) {
        try {
            this.lock.readLock().lock();
            List<TimelineObjectHolder<VersionType, ObjectType>> list = this.lookup(interval, false);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public List<TimelineObjectHolder<VersionType, ObjectType>> lookupWithIncompletePartitions(Interval interval) {
        try {
            this.lock.readLock().lock();
            List<TimelineObjectHolder<VersionType, ObjectType>> list = this.lookup(interval, true);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isEmpty() {
        try {
            this.lock.readLock().lock();
            boolean bl = this.completePartitionsTimeline.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public TimelineObjectHolder<VersionType, ObjectType> first() {
        try {
            this.lock.readLock().lock();
            TimelineObjectHolder<VersionType, ObjectType> timelineObjectHolder = this.timelineEntryToObjectHolder(this.completePartitionsTimeline.firstEntry().getValue());
            return timelineObjectHolder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public TimelineObjectHolder<VersionType, ObjectType> last() {
        try {
            this.lock.readLock().lock();
            TimelineObjectHolder<VersionType, ObjectType> timelineObjectHolder = this.timelineEntryToObjectHolder(this.completePartitionsTimeline.lastEntry().getValue());
            return timelineObjectHolder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private TimelineObjectHolder<VersionType, ObjectType> timelineEntryToObjectHolder(TimelineEntry entry) {
        return new TimelineObjectHolder(entry.getTrueInterval(), entry.getTrueInterval(), entry.getVersion(), new PartitionHolder(entry.getPartitionHolder()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TimelineObjectHolder<VersionType, ObjectType>> findOvershadowed() {
        try {
            Map versionEntry;
            this.lock.readLock().lock();
            HashSet<TimelineObjectHolder<VersionType, ObjectType>> retVal = new HashSet<TimelineObjectHolder<VersionType, ObjectType>>();
            HashMap overShadowed = new HashMap();
            for (Map.Entry<Interval, TreeMap<VersionType, TimelineEntry>> entry : this.allTimelineEntries.entrySet()) {
                HashMap versionCopy = new HashMap();
                versionCopy.putAll(entry.getValue());
                overShadowed.put(entry.getKey(), versionCopy);
            }
            for (Map.Entry<Object, TreeMap<Object, TimelineEntry>> entry : this.completePartitionsTimeline.entrySet()) {
                versionEntry = (Map)overShadowed.get(((TimelineEntry)((Object)entry.getValue())).getTrueInterval());
                if (versionEntry == null) continue;
                versionEntry.remove(((TimelineEntry)((Object)entry.getValue())).getVersion());
                if (!versionEntry.isEmpty()) continue;
                overShadowed.remove(((TimelineEntry)((Object)entry.getValue())).getTrueInterval());
            }
            for (Map.Entry<Object, TreeMap<Object, TimelineEntry>> entry : this.incompletePartitionsTimeline.entrySet()) {
                versionEntry = (Map)overShadowed.get(((TimelineEntry)((Object)entry.getValue())).getTrueInterval());
                if (versionEntry == null) continue;
                versionEntry.remove(((TimelineEntry)((Object)entry.getValue())).getVersion());
                if (!versionEntry.isEmpty()) continue;
                overShadowed.remove(((TimelineEntry)((Object)entry.getValue())).getTrueInterval());
            }
            for (Map.Entry<Object, TreeMap<Object, TimelineEntry>> entry : overShadowed.entrySet()) {
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    TimelineEntry object = (TimelineEntry)entry2.getValue();
                    retVal.add(this.timelineEntryToObjectHolder(object));
                }
            }
            HashSet<TimelineObjectHolder<VersionType, ObjectType>> hashSet = retVal;
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOvershadowed(Interval interval, VersionType version) {
        try {
            this.lock.readLock().lock();
            TimelineEntry entry = (TimelineEntry)this.completePartitionsTimeline.get(interval);
            if (entry != null) {
                boolean bl = this.versionComparator.compare(version, entry.getVersion()) < 0;
                return bl;
            }
            Interval lower = this.completePartitionsTimeline.floorKey(new Interval((ReadableInstant)interval.getStart(), (ReadableInstant)DateTimes.MAX));
            if (lower == null || !lower.overlaps((ReadableInterval)interval)) {
                boolean bl = false;
                return bl;
            }
            Interval prev = null;
            Interval curr = lower;
            do {
                if (curr == null || prev != null && curr.getStartMillis() > prev.getEndMillis() || this.versionComparator.compare(version, ((TimelineEntry)this.completePartitionsTimeline.get(curr)).getVersion()) >= 0) {
                    boolean bl = false;
                    return bl;
                }
                prev = curr;
                curr = this.completePartitionsTimeline.higherKey(curr);
            } while (interval.getEndMillis() > prev.getEndMillis());
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void add(NavigableMap<Interval, TimelineEntry> timeline, Interval interval, TimelineEntry entry) {
        TimelineEntry existsInTimeline = (TimelineEntry)timeline.get(interval);
        if (existsInTimeline != null) {
            int compare = this.versionComparator.compare(entry.getVersion(), existsInTimeline.getVersion());
            if (compare > 0) {
                this.addIntervalToTimeline(interval, entry, timeline);
            }
            return;
        }
        Interval lowerKey = timeline.lowerKey(interval);
        if (lowerKey != null && this.addAtKey(timeline, lowerKey, entry)) {
            return;
        }
        Interval higherKey = timeline.higherKey(interval);
        if (higherKey != null && this.addAtKey(timeline, higherKey, entry)) {
            return;
        }
        this.addIntervalToTimeline(interval, entry, timeline);
    }

    private boolean addAtKey(NavigableMap<Interval, TimelineEntry> timeline, Interval key, TimelineEntry entry) {
        boolean retVal = false;
        Interval currKey = key;
        Object entryInterval = entry.getTrueInterval();
        if (!currKey.overlaps((ReadableInterval)entryInterval)) {
            return false;
        }
        while (entryInterval != null && currKey != null && currKey.overlaps((ReadableInterval)entryInterval)) {
            Interval nextKey = timeline.higherKey(currKey);
            int versionCompare = this.versionComparator.compare(entry.getVersion(), ((TimelineEntry)timeline.get(currKey)).getVersion());
            if (versionCompare < 0) {
                if (currKey.contains((ReadableInterval)entryInterval)) {
                    return true;
                }
                if (currKey.getStart().isBefore((ReadableInstant)entryInterval.getStart())) {
                    entryInterval = new Interval((ReadableInstant)currKey.getEnd(), (ReadableInstant)entryInterval.getEnd());
                } else {
                    this.addIntervalToTimeline(new Interval((ReadableInstant)entryInterval.getStart(), (ReadableInstant)currKey.getStart()), entry, timeline);
                    entryInterval = entryInterval.getEnd().isAfter((ReadableInstant)currKey.getEnd()) ? new Interval((ReadableInstant)currKey.getEnd(), (ReadableInstant)entryInterval.getEnd()) : null;
                }
            } else if (versionCompare > 0) {
                TimelineEntry oldEntry = (TimelineEntry)timeline.remove(currKey);
                if (currKey.contains((ReadableInterval)entryInterval)) {
                    this.addIntervalToTimeline(new Interval((ReadableInstant)currKey.getStart(), (ReadableInstant)entryInterval.getStart()), oldEntry, timeline);
                    this.addIntervalToTimeline(new Interval((ReadableInstant)entryInterval.getEnd(), (ReadableInstant)currKey.getEnd()), oldEntry, timeline);
                    this.addIntervalToTimeline((Interval)entryInterval, entry, timeline);
                    return true;
                }
                if (currKey.getStart().isBefore((ReadableInstant)entryInterval.getStart())) {
                    this.addIntervalToTimeline(new Interval((ReadableInstant)currKey.getStart(), (ReadableInstant)entryInterval.getStart()), oldEntry, timeline);
                } else if (entryInterval.getEnd().isBefore((ReadableInstant)currKey.getEnd())) {
                    this.addIntervalToTimeline(new Interval((ReadableInstant)entryInterval.getEnd(), (ReadableInstant)currKey.getEnd()), oldEntry, timeline);
                }
            } else if (((TimelineEntry)timeline.get(currKey)).equals(entry)) {
                timeline.remove(currKey);
            } else {
                throw new UOE("Cannot add overlapping segments [%s and %s] with the same version [%s]", currKey, entryInterval, entry.getVersion());
            }
            currKey = nextKey;
            retVal = true;
        }
        this.addIntervalToTimeline((Interval)entryInterval, entry, timeline);
        return retVal;
    }

    private void addIntervalToTimeline(Interval interval, TimelineEntry entry, NavigableMap<Interval, TimelineEntry> timeline) {
        if (interval != null && interval.toDurationMillis() > 0L) {
            timeline.put(interval, entry);
        }
    }

    private void remove(NavigableMap<Interval, TimelineEntry> timeline, Interval interval, TimelineEntry entry, boolean incompleteOk) {
        ArrayList<Object> intervalsToRemove = new ArrayList<Object>();
        TimelineEntry removed = (TimelineEntry)timeline.get(interval);
        if (removed == null) {
            for (Map.Entry entry2 : timeline.entrySet()) {
                if (entry2.getValue() != entry) continue;
                intervalsToRemove.add(entry2.getKey());
            }
        } else {
            intervalsToRemove.add(interval);
        }
        for (Interval interval2 : intervalsToRemove) {
            this.remove(timeline, interval2, incompleteOk);
        }
    }

    private void remove(NavigableMap<Interval, TimelineEntry> timeline, Interval interval, boolean incompleteOk) {
        timeline.remove(interval);
        block0: for (Map.Entry<Interval, TreeMap<VersionType, TimelineEntry>> versionEntry : this.allTimelineEntries.entrySet()) {
            if (versionEntry.getKey().overlap((ReadableInterval)interval) == null) continue;
            if (incompleteOk) {
                this.add(timeline, versionEntry.getKey(), versionEntry.getValue().lastEntry().getValue());
                continue;
            }
            for (VersionType ver : versionEntry.getValue().descendingKeySet()) {
                TimelineEntry timelineEntry = versionEntry.getValue().get(ver);
                if (!timelineEntry.getPartitionHolder().isComplete()) continue;
                this.add(timeline, versionEntry.getKey(), timelineEntry);
                continue block0;
            }
        }
    }

    private List<TimelineObjectHolder<VersionType, ObjectType>> lookup(Interval interval, boolean incompleteOk) {
        TimelineObjectHolder lastEntry;
        ArrayList<TimelineObjectHolder<VersionType, ObjectType>> retVal = new ArrayList<TimelineObjectHolder<VersionType, ObjectType>>();
        NavigableMap<Interval, TimelineEntry> timeline = incompleteOk ? this.incompletePartitionsTimeline : this.completePartitionsTimeline;
        for (Map.Entry entry : timeline.entrySet()) {
            Interval timelineInterval = (Interval)entry.getKey();
            TimelineEntry val = (TimelineEntry)entry.getValue();
            if (!timelineInterval.overlaps((ReadableInterval)interval)) continue;
            retVal.add(new TimelineObjectHolder(timelineInterval, val.getTrueInterval(), val.getVersion(), new PartitionHolder(val.getPartitionHolder())));
        }
        if (retVal.isEmpty()) {
            return retVal;
        }
        TimelineObjectHolder firstEntry = (TimelineObjectHolder)retVal.get(0);
        if (interval.overlaps((ReadableInterval)firstEntry.getInterval()) && interval.getStart().isAfter((ReadableInstant)firstEntry.getInterval().getStart())) {
            retVal.set(0, new TimelineObjectHolder(new Interval((ReadableInstant)interval.getStart(), (ReadableInstant)firstEntry.getInterval().getEnd()), firstEntry.getTrueInterval(), firstEntry.getVersion(), firstEntry.getObject()));
        }
        if (interval.overlaps((ReadableInterval)(lastEntry = (TimelineObjectHolder)retVal.get(retVal.size() - 1)).getInterval()) && interval.getEnd().isBefore((ReadableInstant)lastEntry.getInterval().getEnd())) {
            retVal.set(retVal.size() - 1, new TimelineObjectHolder(new Interval((ReadableInstant)lastEntry.getInterval().getStart(), (ReadableInstant)interval.getEnd()), lastEntry.getTrueInterval(), lastEntry.getVersion(), lastEntry.getObject()));
        }
        return retVal;
    }

    public class TimelineEntry {
        private final Interval trueInterval;
        private final VersionType version;
        private final PartitionHolder<ObjectType> partitionHolder;

        TimelineEntry(Interval trueInterval, VersionType version, PartitionHolder<ObjectType> partitionHolder) {
            this.trueInterval = (Interval)Preconditions.checkNotNull((Object)trueInterval);
            this.version = Preconditions.checkNotNull(version);
            this.partitionHolder = (PartitionHolder)Preconditions.checkNotNull(partitionHolder);
        }

        Interval getTrueInterval() {
            return this.trueInterval;
        }

        public VersionType getVersion() {
            return this.version;
        }

        public PartitionHolder<ObjectType> getPartitionHolder() {
            return this.partitionHolder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimelineEntry that = (TimelineEntry)o;
            if (!this.trueInterval.equals((Object)that.trueInterval)) {
                return false;
            }
            if (!this.version.equals(that.version)) {
                return false;
            }
            return this.partitionHolder.equals(that.partitionHolder);
        }

        public int hashCode() {
            return Objects.hash(this.trueInterval, this.version, this.partitionHolder);
        }
    }
}

