/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.inject.Inject;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.jackson.CommaListJoinDeserializer;
import org.apache.druid.jackson.CommaListJoinSerializer;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.timeline.PruneLoadSpec;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class DataSegment
implements Comparable<DataSegment> {
    private static final Interner<String> STRING_INTERNER = Interners.newWeakInterner();
    private static final Interner<List<String>> DIMENSIONS_INTERNER = Interners.newWeakInterner();
    private static final Interner<List<String>> METRICS_INTERNER = Interners.newWeakInterner();
    private static final Map<String, Object> PRUNED_LOAD_SPEC = ImmutableMap.of((Object)"load spec is pruned, because it's not needed on Brokers, but eats a lot of heap space", (Object)"");
    private final Integer binaryVersion;
    private final SegmentId id;
    @Nullable
    private final Map<String, Object> loadSpec;
    private final List<String> dimensions;
    private final List<String> metrics;
    private final ShardSpec shardSpec;
    private final long size;

    public DataSegment(String dataSource, Interval interval, String version, Map<String, Object> loadSpec, List<String> dimensions, List<String> metrics, ShardSpec shardSpec, Integer binaryVersion, long size) {
        this(dataSource, interval, version, loadSpec, dimensions, metrics, shardSpec, binaryVersion, size, PruneLoadSpecHolder.DEFAULT);
    }

    @JsonCreator
    public DataSegment(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="version") String version, @JsonProperty(value="loadSpec") @Nullable Map<String, Object> loadSpec, @JsonProperty(value="dimensions") @JsonDeserialize(using=CommaListJoinDeserializer.class) @Nullable List<String> dimensions, @JsonProperty(value="metrics") @JsonDeserialize(using=CommaListJoinDeserializer.class) @Nullable List<String> metrics, @JsonProperty(value="shardSpec") @Nullable ShardSpec shardSpec, @JsonProperty(value="binaryVersion") Integer binaryVersion, @JsonProperty(value="size") long size, @JacksonInject PruneLoadSpecHolder pruneLoadSpecHolder) {
        this.id = SegmentId.of(dataSource, interval, version, shardSpec);
        this.loadSpec = pruneLoadSpecHolder.pruneLoadSpec ? PRUNED_LOAD_SPEC : this.prepareLoadSpec(loadSpec);
        this.dimensions = this.prepareDimensionsOrMetrics(dimensions, DIMENSIONS_INTERNER);
        this.metrics = this.prepareDimensionsOrMetrics(metrics, METRICS_INTERNER);
        this.shardSpec = shardSpec == null ? NoneShardSpec.instance() : shardSpec;
        this.binaryVersion = binaryVersion;
        this.size = size;
    }

    @Nullable
    private Map<String, Object> prepareLoadSpec(@Nullable Map<String, Object> loadSpec) {
        if (loadSpec == null) {
            return null;
        }
        Object2ObjectArrayMap result = new Object2ObjectArrayMap(loadSpec.size());
        for (Map.Entry<String, Object> e : loadSpec.entrySet()) {
            result.put(STRING_INTERNER.intern((Object)e.getKey()), e.getValue());
        }
        return result;
    }

    private List<String> prepareDimensionsOrMetrics(@Nullable List<String> list, Interner<List<String>> interner) {
        if (list == null) {
            return ImmutableList.of();
        }
        List result = (List)list.stream().filter(s -> !Strings.isNullOrEmpty((String)s)).map(arg_0 -> STRING_INTERNER.intern(arg_0)).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
        return (List)interner.intern((Object)result);
    }

    @JsonProperty
    public String getDataSource() {
        return this.id.getDataSource();
    }

    @JsonProperty
    public Interval getInterval() {
        return this.id.getInterval();
    }

    @Nullable
    @JsonProperty
    public Map<String, Object> getLoadSpec() {
        return this.loadSpec;
    }

    @JsonProperty
    public String getVersion() {
        return this.id.getVersion();
    }

    @JsonProperty
    @JsonSerialize(using=CommaListJoinSerializer.class)
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty
    @JsonSerialize(using=CommaListJoinSerializer.class)
    public List<String> getMetrics() {
        return this.metrics;
    }

    @JsonProperty
    public ShardSpec getShardSpec() {
        return this.shardSpec;
    }

    @JsonProperty
    public Integer getBinaryVersion() {
        return this.binaryVersion;
    }

    @JsonProperty
    public long getSize() {
        return this.size;
    }

    @JsonProperty(value="identifier", access=JsonProperty.Access.READ_ONLY)
    public SegmentId getId() {
        return this.id;
    }

    public SegmentDescriptor toDescriptor() {
        return new SegmentDescriptor(this.getInterval(), this.getVersion(), this.shardSpec.getPartitionNum());
    }

    public DataSegment withLoadSpec(Map<String, Object> loadSpec) {
        return DataSegment.builder(this).loadSpec(loadSpec).build();
    }

    public DataSegment withDimensions(List<String> dimensions) {
        return DataSegment.builder(this).dimensions(dimensions).build();
    }

    public DataSegment withMetrics(List<String> metrics) {
        return DataSegment.builder(this).metrics(metrics).build();
    }

    public DataSegment withSize(long size) {
        return DataSegment.builder(this).size(size).build();
    }

    public DataSegment withVersion(String version) {
        return DataSegment.builder(this).version(version).build();
    }

    public DataSegment withBinaryVersion(int binaryVersion) {
        return DataSegment.builder(this).binaryVersion(binaryVersion).build();
    }

    @Override
    public int compareTo(DataSegment dataSegment) {
        return this.getId().compareTo(dataSegment.getId());
    }

    public boolean equals(Object o) {
        if (o instanceof DataSegment) {
            return this.getId().equals(((DataSegment)o).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "DataSegment{size=" + this.size + ", shardSpec=" + this.shardSpec + ", metrics=" + this.metrics + ", dimensions=" + this.dimensions + ", version='" + this.getVersion() + '\'' + ", loadSpec=" + this.loadSpec + ", interval=" + this.getInterval() + ", dataSource='" + this.getDataSource() + '\'' + ", binaryVersion='" + this.binaryVersion + '\'' + '}';
    }

    public static Comparator<DataSegment> bucketMonthComparator() {
        return new Comparator<DataSegment>(){

            @Override
            public int compare(DataSegment lhs, DataSegment rhs) {
                DateTime rhsMonth;
                DateTime lhsMonth = Granularities.MONTH.bucketStart(lhs.getInterval().getStart());
                int retVal = lhsMonth.compareTo((ReadableInstant)(rhsMonth = Granularities.MONTH.bucketStart(rhs.getInterval().getStart())));
                if (retVal != 0) {
                    return retVal;
                }
                return lhs.compareTo(rhs);
            }
        };
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DataSegment segment) {
        return new Builder(segment);
    }

    public static class Builder {
        private String dataSource;
        private Interval interval;
        private String version;
        private Map<String, Object> loadSpec;
        private List<String> dimensions;
        private List<String> metrics;
        private ShardSpec shardSpec;
        private Integer binaryVersion;
        private long size;

        public Builder() {
            this.loadSpec = ImmutableMap.of();
            this.dimensions = ImmutableList.of();
            this.metrics = ImmutableList.of();
            this.shardSpec = NoneShardSpec.instance();
            this.size = -1L;
        }

        public Builder(DataSegment segment) {
            this.dataSource = segment.getDataSource();
            this.interval = segment.getInterval();
            this.version = segment.getVersion();
            this.loadSpec = segment.getLoadSpec();
            this.dimensions = segment.getDimensions();
            this.metrics = segment.getMetrics();
            this.shardSpec = segment.getShardSpec();
            this.binaryVersion = segment.getBinaryVersion();
            this.size = segment.getSize();
        }

        public Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Builder interval(Interval interval) {
            this.interval = interval;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder loadSpec(Map<String, Object> loadSpec) {
            this.loadSpec = loadSpec;
            return this;
        }

        public Builder dimensions(List<String> dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public Builder metrics(List<String> metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder shardSpec(ShardSpec shardSpec) {
            this.shardSpec = shardSpec;
            return this;
        }

        public Builder binaryVersion(Integer binaryVersion) {
            this.binaryVersion = binaryVersion;
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public DataSegment build() {
            Preconditions.checkNotNull((Object)this.dataSource, (Object)"dataSource");
            Preconditions.checkNotNull((Object)this.interval, (Object)"interval");
            Preconditions.checkNotNull((Object)this.version, (Object)"version");
            Preconditions.checkNotNull((Object)this.shardSpec, (Object)"shardSpec");
            return new DataSegment(this.dataSource, this.interval, this.version, this.loadSpec, this.dimensions, this.metrics, this.shardSpec, this.binaryVersion, this.size);
        }
    }

    @VisibleForTesting
    public static class PruneLoadSpecHolder {
        @VisibleForTesting
        public static final PruneLoadSpecHolder DEFAULT = new PruneLoadSpecHolder();
        @Inject(optional=true)
        @PruneLoadSpec
        boolean pruneLoadSpec = false;
    }
}

