/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import javax.annotation.Nonnull;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.UnaryExpr;

class UnaryMinusExpr
extends UnaryExpr {
    UnaryMinusExpr(Expr expr) {
        super(expr);
    }

    @Override
    @Nonnull
    public ExprEval eval(Expr.ObjectBinding bindings) {
        ExprEval ret = this.expr.eval(bindings);
        if (NullHandling.sqlCompatible() && ret.value() == null) {
            return ExprEval.of(null);
        }
        if (ret.type() == ExprType.LONG) {
            return ExprEval.of(-ret.asLong());
        }
        if (ret.type() == ExprType.DOUBLE) {
            return ExprEval.of(-ret.asDouble());
        }
        throw new IAE("unsupported type " + (Object)((Object)ret.type()), new Object[0]);
    }

    @Override
    public void visit(Expr.Visitor visitor) {
        this.expr.visit(visitor);
        visitor.visit(this);
    }

    public String toString() {
        return "-" + this.expr;
    }
}

