/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.BinaryOpExprBase;
import org.apache.druid.math.expr.ConstantExpr;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprListenerImpl;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.Function;
import org.apache.druid.math.expr.FunctionExpr;
import org.apache.druid.math.expr.IdentifierExpr;
import org.apache.druid.math.expr.UnaryExpr;
import org.apache.druid.math.expr.UnaryMinusExpr;
import org.apache.druid.math.expr.UnaryNotExpr;
import org.apache.druid.math.expr.antlr.ExprLexer;
import org.apache.druid.math.expr.antlr.ExprParser;

public class Parser {
    private static final Logger log = new Logger(Parser.class);
    private static final Map<String, Function> FUNCTIONS;

    public static Function getFunction(String name) {
        return FUNCTIONS.get(StringUtils.toLowerCase(name));
    }

    public static Expr parse(String in, ExprMacroTable macroTable) {
        return Parser.parse(in, macroTable, true);
    }

    @VisibleForTesting
    static Expr parse(String in, ExprMacroTable macroTable, boolean withFlatten) {
        ExprLexer lexer = new ExprLexer((CharStream)new ANTLRInputStream(in));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ExprParser parser = new ExprParser((TokenStream)tokens);
        parser.setBuildParseTree(true);
        ExprParser.ExprContext parseTree = parser.expr();
        ParseTreeWalker walker = new ParseTreeWalker();
        ExprListenerImpl listener = new ExprListenerImpl((ParseTree)parseTree, macroTable);
        walker.walk((ParseTreeListener)listener, (ParseTree)parseTree);
        return withFlatten ? Parser.flatten(listener.getAST()) : listener.getAST();
    }

    public static Expr flatten(Expr expr) {
        if (expr instanceof BinaryOpExprBase) {
            Expr right;
            BinaryOpExprBase binary = (BinaryOpExprBase)expr;
            Expr left = Parser.flatten(binary.left);
            if (Evals.isAllConstants(left, right = Parser.flatten(binary.right))) {
                expr = expr.eval(null).toExpr();
            } else if (left != binary.left || right != binary.right) {
                return Evals.binaryOp(binary, left, right);
            }
        } else if (expr instanceof UnaryExpr) {
            UnaryExpr unary = (UnaryExpr)expr;
            Expr eval = Parser.flatten(unary.expr);
            if (eval instanceof ConstantExpr) {
                expr = expr.eval(null).toExpr();
            } else if (eval != unary.expr) {
                expr = expr instanceof UnaryMinusExpr ? new UnaryMinusExpr(eval) : (expr instanceof UnaryNotExpr ? new UnaryNotExpr(eval) : unary);
            }
        } else if (expr instanceof FunctionExpr) {
            FunctionExpr functionExpr = (FunctionExpr)expr;
            List<Expr> args = functionExpr.args;
            boolean flattened = false;
            ArrayList flattening = Lists.newArrayListWithCapacity((int)args.size());
            for (Expr arg : args) {
                Expr flatten = Parser.flatten(arg);
                flattened |= flatten != arg;
                flattening.add(flatten);
            }
            if (Evals.isAllConstants(flattening)) {
                expr = expr.eval(null).toExpr();
            } else if (flattened) {
                expr = new FunctionExpr(functionExpr.function, functionExpr.name, flattening);
            }
        }
        return expr;
    }

    public static List<String> findRequiredBindings(Expr expr) {
        final LinkedHashSet found = new LinkedHashSet();
        expr.visit(new Expr.Visitor(){

            @Override
            public void visit(Expr expr) {
                if (expr instanceof IdentifierExpr) {
                    found.add(expr.toString());
                }
            }
        });
        return Lists.newArrayList(found);
    }

    @Nullable
    public static String getIdentifierIfIdentifier(Expr expr) {
        if (expr instanceof IdentifierExpr) {
            return expr.toString();
        }
        return null;
    }

    public static Expr.ObjectBinding withMap(Map<String, ?> bindings) {
        return bindings::get;
    }

    public static Expr.ObjectBinding withSuppliers(Map<String, Supplier<Object>> bindings) {
        return name -> {
            Supplier supplier = (Supplier)bindings.get(name);
            return supplier == null ? null : supplier.get();
        };
    }

    static {
        HashMap<String, Function> functionMap = new HashMap<String, Function>();
        for (Class<?> clazz : Function.class.getClasses()) {
            if (Modifier.isAbstract(clazz.getModifiers()) || !Function.class.isAssignableFrom(clazz)) continue;
            try {
                Function function = (Function)clazz.newInstance();
                functionMap.put(StringUtils.toLowerCase(function.name()), function);
            }
            catch (Exception e) {
                log.info("failed to instantiate " + clazz.getName() + ".. ignoring", e);
            }
        }
        FUNCTIONS = ImmutableMap.copyOf(functionMap);
    }
}

