/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.druid.math.expr.ConstantExpr;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;

class LongExpr
extends ConstantExpr {
    private final Long value;

    public LongExpr(Long value) {
        this.value = (Long)Preconditions.checkNotNull((Object)value, (Object)"value");
    }

    @Override
    @Nonnull
    public Object getLiteralValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    @Nonnull
    public ExprEval eval(Expr.ObjectBinding bindings) {
        return ExprEval.ofLong(this.value);
    }
}

