/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.primitives.Doubles;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.math.expr.DoubleExpr;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.LongExpr;
import org.apache.druid.math.expr.StringExpr;

public abstract class ExprEval<T> {
    private boolean stringValueValid = false;
    private String stringValue;
    @Nullable
    final T value;

    public static ExprEval ofLong(@Nullable Number longValue) {
        return new LongExprEval(longValue);
    }

    public static ExprEval of(long longValue) {
        return new LongExprEval(longValue);
    }

    public static ExprEval ofDouble(@Nullable Number doubleValue) {
        return new DoubleExprEval(doubleValue);
    }

    public static ExprEval of(double doubleValue) {
        return new DoubleExprEval(doubleValue);
    }

    public static ExprEval of(@Nullable String stringValue) {
        if (stringValue == null) {
            return StringExprEval.OF_NULL;
        }
        return new StringExprEval(stringValue);
    }

    public static ExprEval of(boolean value, ExprType type) {
        switch (type) {
            case DOUBLE: {
                return ExprEval.of(Evals.asDouble(value));
            }
            case LONG: {
                return ExprEval.of(Evals.asLong(value));
            }
            case STRING: {
                return ExprEval.of(String.valueOf(value));
            }
        }
        throw new IllegalArgumentException("invalid type " + (Object)((Object)type));
    }

    public static ExprEval bestEffortOf(@Nullable Object val) {
        if (val instanceof ExprEval) {
            return (ExprEval)val;
        }
        if (val instanceof Number) {
            if (val instanceof Float || val instanceof Double) {
                return new DoubleExprEval((Number)val);
            }
            return new LongExprEval((Number)val);
        }
        return new StringExprEval(val == null ? null : String.valueOf(val));
    }

    private ExprEval(@Nullable T value) {
        this.value = value;
    }

    public abstract ExprType type();

    public Object value() {
        return this.value;
    }

    public abstract boolean isNumericNull();

    public abstract int asInt();

    public abstract long asLong();

    public abstract double asDouble();

    @Nullable
    public String asString() {
        if (!this.stringValueValid) {
            this.stringValue = this.value == null ? null : String.valueOf(this.value);
            this.stringValueValid = true;
        }
        return this.stringValue;
    }

    public abstract boolean asBoolean();

    public abstract ExprEval castTo(ExprType var1);

    public abstract Expr toExpr();

    private static class StringExprEval
    extends ExprEval<String> {
        private boolean intValueValid = false;
        private boolean longValueValid = false;
        private boolean doubleValueValid = false;
        private boolean booleanValueValid = false;
        private int intValue;
        private long longValue;
        private double doubleValue;
        private boolean booleanValue;
        private static final StringExprEval OF_NULL = new StringExprEval(null);
        private Number numericVal;

        private StringExprEval(@Nullable String value) {
            super(NullHandling.emptyToNullIfNeeded(value));
        }

        @Override
        public final ExprType type() {
            return ExprType.STRING;
        }

        @Override
        public int asInt() {
            if (!this.intValueValid) {
                this.intValue = this.computeInt();
                this.intValueValid = true;
            }
            return this.intValue;
        }

        @Override
        public long asLong() {
            if (!this.longValueValid) {
                this.longValue = this.computeLong();
                this.longValueValid = true;
            }
            return this.longValue;
        }

        @Override
        public double asDouble() {
            if (!this.doubleValueValid) {
                this.doubleValue = this.computeDouble();
                this.doubleValueValid = true;
            }
            return this.doubleValue;
        }

        @Override
        @Nullable
        public String asString() {
            return (String)this.value;
        }

        private int computeInt() {
            Number number = this.computeNumber();
            if (number == null) {
                assert (NullHandling.replaceWithDefault());
                return 0;
            }
            return number.intValue();
        }

        private long computeLong() {
            Number number = this.computeNumber();
            if (number == null) {
                assert (NullHandling.replaceWithDefault());
                return 0L;
            }
            return number.longValue();
        }

        private double computeDouble() {
            Number number = this.computeNumber();
            if (number == null) {
                assert (NullHandling.replaceWithDefault());
                return 0.0;
            }
            return number.doubleValue();
        }

        @Nullable
        private Number computeNumber() {
            if (this.value == null) {
                return null;
            }
            if (this.numericVal != null) {
                return this.numericVal;
            }
            Long v = GuavaUtils.tryParseLong((String)this.value);
            Number rv = v != null ? (Number)v : (Number)Doubles.tryParse((String)((String)this.value));
            this.numericVal = rv;
            return rv;
        }

        @Override
        public boolean isNumericNull() {
            return this.computeNumber() == null;
        }

        @Override
        public final boolean asBoolean() {
            if (!this.booleanValueValid) {
                this.booleanValue = Evals.asBoolean((String)this.value);
                this.booleanValueValid = true;
            }
            return this.booleanValue;
        }

        @Override
        public final ExprEval castTo(ExprType castTo) {
            switch (castTo) {
                case DOUBLE: {
                    return ExprEval.ofDouble(this.computeNumber());
                }
                case LONG: {
                    return ExprEval.ofLong(this.computeNumber());
                }
                case STRING: {
                    return this;
                }
            }
            throw new IAE("invalid type " + (Object)((Object)castTo), new Object[0]);
        }

        @Override
        public Expr toExpr() {
            return new StringExpr((String)this.value);
        }
    }

    private static class LongExprEval
    extends NumericExprEval {
        private LongExprEval(@Nullable Number value) {
            super(value == null ? (Number)NullHandling.defaultLongValue() : (Number)value);
        }

        @Override
        public final ExprType type() {
            return ExprType.LONG;
        }

        @Override
        public final boolean asBoolean() {
            return Evals.asBoolean(this.asLong());
        }

        @Override
        public final ExprEval castTo(ExprType castTo) {
            switch (castTo) {
                case DOUBLE: {
                    if (this.value == null) {
                        return ExprEval.ofDouble(null);
                    }
                    return ExprEval.of(this.asDouble());
                }
                case LONG: {
                    return this;
                }
                case STRING: {
                    return ExprEval.of(this.asString());
                }
            }
            throw new IAE("invalid type " + (Object)((Object)castTo), new Object[0]);
        }

        @Override
        public Expr toExpr() {
            return new LongExpr(((Number)this.value).longValue());
        }
    }

    private static class DoubleExprEval
    extends NumericExprEval {
        private DoubleExprEval(@Nullable Number value) {
            super(value == null ? (Number)NullHandling.defaultDoubleValue() : (Number)value);
        }

        @Override
        public final ExprType type() {
            return ExprType.DOUBLE;
        }

        @Override
        public final boolean asBoolean() {
            return Evals.asBoolean(this.asDouble());
        }

        @Override
        public final ExprEval castTo(ExprType castTo) {
            switch (castTo) {
                case DOUBLE: {
                    return this;
                }
                case LONG: {
                    if (this.value == null) {
                        return ExprEval.ofLong(null);
                    }
                    return ExprEval.of(this.asLong());
                }
                case STRING: {
                    return ExprEval.of(this.asString());
                }
            }
            throw new IAE("invalid type " + (Object)((Object)castTo), new Object[0]);
        }

        @Override
        public Expr toExpr() {
            return new DoubleExpr(((Number)this.value).doubleValue());
        }
    }

    private static abstract class NumericExprEval
    extends ExprEval<Number> {
        private NumericExprEval(@Nullable Number value) {
            super(value);
        }

        @Override
        public final int asInt() {
            return ((Number)this.value).intValue();
        }

        @Override
        public final long asLong() {
            return ((Number)this.value).longValue();
        }

        @Override
        public final double asDouble() {
            return ((Number)this.value).doubleValue();
        }

        @Override
        public boolean isNumericNull() {
            return this.value == null;
        }
    }
}

