/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import java.util.Arrays;
import java.util.List;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.math.expr.BinaryOpExprBase;
import org.apache.druid.math.expr.ConstantExpr;
import org.apache.druid.math.expr.Expr;

public class Evals {
    private static final Logger log = new Logger(Evals.class);

    public static boolean isAllConstants(Expr ... exprs) {
        return Evals.isAllConstants(Arrays.asList(exprs));
    }

    public static boolean isAllConstants(List<Expr> exprs) {
        for (Expr expr : exprs) {
            if (expr instanceof ConstantExpr) continue;
            return false;
        }
        return true;
    }

    public static Expr binaryOp(BinaryOpExprBase binary, Expr left, Expr right) {
        try {
            return (Expr)binary.getClass().getDeclaredConstructor(String.class, Expr.class, Expr.class).newInstance(binary.op, left, right);
        }
        catch (Exception e) {
            log.warn(e, "failed to rewrite expression " + binary, new Object[0]);
            return binary;
        }
    }

    public static long asLong(boolean x) {
        return x ? 1L : 0L;
    }

    public static double asDouble(boolean x) {
        return x ? 1.0 : 0.0;
    }

    public static boolean asBoolean(long x) {
        return x > 0L;
    }

    public static boolean asBoolean(double x) {
        return x > 0.0;
    }

    public static boolean asBoolean(String x) {
        return !NullHandling.isNullOrEquivalent(x) && Boolean.valueOf(x) != false;
    }
}

