/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.druid.math.expr.ConstantExpr;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;

class DoubleExpr
extends ConstantExpr {
    private final Double value;

    public DoubleExpr(Double value) {
        this.value = (Double)Preconditions.checkNotNull((Object)value, (Object)"value");
    }

    @Override
    @Nonnull
    public Object getLiteralValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    @Nonnull
    public ExprEval eval(Expr.ObjectBinding bindings) {
        return ExprEval.ofDouble(this.value);
    }
}

