/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.math.expr.BinaryOpExprBase;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;

abstract class BinaryEvalOpExprBase
extends BinaryOpExprBase {
    public BinaryEvalOpExprBase(String op, Expr left, Expr right) {
        super(op, left, right);
    }

    @Override
    @Nonnull
    public ExprEval eval(Expr.ObjectBinding bindings) {
        ExprEval leftVal = this.left.eval(bindings);
        ExprEval rightVal = this.right.eval(bindings);
        if (NullHandling.sqlCompatible() && (leftVal.value() == null || rightVal.value() == null)) {
            return ExprEval.of(null);
        }
        if (leftVal.type() == ExprType.STRING && rightVal.type() == ExprType.STRING) {
            return this.evalString(leftVal.asString(), rightVal.asString());
        }
        if (leftVal.type() == ExprType.LONG && rightVal.type() == ExprType.LONG) {
            if (NullHandling.sqlCompatible() && (leftVal.isNumericNull() || rightVal.isNumericNull())) {
                return ExprEval.of(null);
            }
            return ExprEval.of(this.evalLong(leftVal.asLong(), rightVal.asLong()));
        }
        if (NullHandling.sqlCompatible() && (leftVal.isNumericNull() || rightVal.isNumericNull())) {
            return ExprEval.of(null);
        }
        return ExprEval.of(this.evalDouble(leftVal.asDouble(), rightVal.asDouble()));
    }

    protected ExprEval evalString(@Nullable String left, @Nullable String right) {
        throw new IllegalArgumentException("unsupported type " + (Object)((Object)ExprType.STRING));
    }

    protected abstract long evalLong(long var1, long var3);

    protected abstract double evalDouble(double var1, double var3);
}

