/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.http.client.response;

import java.nio.charset.Charset;
import org.apache.druid.java.util.http.client.response.ClientResponse;
import org.apache.druid.java.util.http.client.response.FullResponseHolder;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class FullResponseHandler
implements HttpResponseHandler<FullResponseHolder, FullResponseHolder> {
    private final Charset charset;

    public FullResponseHandler(Charset charset) {
        this.charset = charset;
    }

    @Override
    public ClientResponse<FullResponseHolder> handleResponse(HttpResponse response, HttpResponseHandler.TrafficCop trafficCop) {
        return ClientResponse.unfinished(new FullResponseHolder(response.getStatus(), response, new StringBuilder(response.getContent().toString(this.charset))));
    }

    @Override
    public ClientResponse<FullResponseHolder> handleChunk(ClientResponse<FullResponseHolder> response, HttpChunk chunk, long chunkNum) {
        StringBuilder builder = response.getObj().getBuilder();
        if (builder == null) {
            return ClientResponse.finished(null);
        }
        builder.append(chunk.getContent().toString(this.charset));
        return response;
    }

    @Override
    public ClientResponse<FullResponseHolder> done(ClientResponse<FullResponseHolder> response) {
        return ClientResponse.finished(response.getObj());
    }

    @Override
    public void exceptionCaught(ClientResponse<FullResponseHolder> clientResponse, Throwable e) {
    }
}

