/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.concurrent;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ListenableFutures {
    public static <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> inFuture, final Function<I, ListenableFuture<O>> transform) {
        final SettableFuture finalFuture = SettableFuture.create();
        Futures.addCallback(inFuture, (FutureCallback)new FutureCallback<I>(){

            public void onSuccess(@Nullable I result) {
                ListenableFuture transformFuture = (ListenableFuture)transform.apply(result);
                Futures.addCallback((ListenableFuture)transformFuture, (FutureCallback)new FutureCallback<O>(){

                    public void onSuccess(@Nullable O result) {
                        finalFuture.set(result);
                    }

                    public void onFailure(Throwable t) {
                        finalFuture.setException(t);
                    }
                });
            }

            public void onFailure(Throwable t) {
                finalFuture.setException(t);
            }
        });
        return finalFuture;
    }
}

