/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.concurrent;

import org.apache.druid.utils.JvmUtils;
import org.skife.config.Config;
import org.skife.config.Default;

public abstract class ExecutorServiceConfig {
    public static final int DEFAULT_NUM_THREADS = -1;

    @Config(value={"${base_path}.formatString"})
    @Default(value="processing-%s")
    public abstract String getFormatString();

    public int getNumThreads() {
        int numThreadsConfigured = this.getNumThreadsConfigured();
        if (numThreadsConfigured != -1) {
            return numThreadsConfigured;
        }
        return Math.max(JvmUtils.getRuntimeInfo().getAvailableProcessors() - 1, 1);
    }

    @Config(value={"${base_path}.numThreads"})
    public int getNumThreadsConfigured() {
        return -1;
    }
}

