/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.IllegalFormatException;
import java.util.Locale;
import javax.annotation.Nullable;

public class StringUtils {
    public static final byte[] EMPTY_BYTES = new byte[0];
    @Deprecated
    public static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;
    public static final String UTF8_STRING = StandardCharsets.UTF_8.toString();
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();

    public static int estimatedBinaryLengthAsUTF8(String value) {
        int length = 0;
        for (int i = 0; i < value.length(); ++i) {
            char var10 = value.charAt(i);
            if (var10 < '\u0080') {
                ++length;
                continue;
            }
            if (var10 < '\u0800') {
                length += 2;
                continue;
            }
            if (Character.isSurrogate(var10)) {
                length += 4;
                ++i;
                continue;
            }
            length += 3;
        }
        return length;
    }

    public static byte[] toUtf8WithNullToEmpty(String string) {
        return string == null ? EMPTY_BYTES : StringUtils.toUtf8(string);
    }

    public static String fromUtf8(byte[] bytes) {
        try {
            return new String(bytes, UTF8_STRING);
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static String fromUtf8(ByteBuffer buffer, int numBytes) {
        byte[] bytes = new byte[numBytes];
        buffer.get(bytes);
        return StringUtils.fromUtf8(bytes);
    }

    public static String fromUtf8(ByteBuffer buffer) {
        return StringUtils.fromUtf8(buffer, buffer.remaining());
    }

    public static byte[] toUtf8(String string) {
        try {
            return string.getBytes(UTF8_STRING);
        }
        catch (UnsupportedEncodingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Nullable
    public static byte[] toUtf8Nullable(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return StringUtils.toUtf8(string);
    }

    public static String format(String message, Object ... formatArgs) {
        return String.format(Locale.ENGLISH, message, formatArgs);
    }

    public static String nonStrictFormat(String message, Object ... formatArgs) {
        if (formatArgs == null || formatArgs.length == 0) {
            return message;
        }
        try {
            return String.format(Locale.ENGLISH, message, formatArgs);
        }
        catch (IllegalFormatException e) {
            StringBuilder bob = new StringBuilder(message);
            for (Object formatArg : formatArgs) {
                bob.append("; ").append(formatArg);
            }
            return bob.toString();
        }
    }

    public static String toLowerCase(String s) {
        return s.toLowerCase(Locale.ENGLISH);
    }

    public static String toUpperCase(String s) {
        return s.toUpperCase(Locale.ENGLISH);
    }

    @Nullable
    public static String urlEncode(String s) {
        if (s == null) {
            return null;
        }
        try {
            return StringUtils.replace(URLEncoder.encode(s, "UTF-8"), "+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static String urlDecode(String s) {
        if (s == null) {
            return null;
        }
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String removeChar(String s, char c) {
        int pos = s.indexOf(c);
        if (pos < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() - 1);
        int prevPos = 0;
        do {
            sb.append(s, prevPos, pos);
            prevPos = pos + 1;
        } while ((pos = s.indexOf(c, pos + 1)) > 0);
        sb.append(s, prevPos, s.length());
        return sb.toString();
    }

    public static String replaceChar(String s, char c, String replacement) {
        int pos = s.indexOf(c);
        if (pos < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() - 1 + replacement.length());
        int prevPos = 0;
        do {
            sb.append(s, prevPos, pos);
            sb.append(replacement);
            prevPos = pos + 1;
        } while ((pos = s.indexOf(c, pos + 1)) > 0);
        sb.append(s, prevPos, s.length());
        return sb.toString();
    }

    public static String replace(String s, String target, String replacement) {
        int pos = s.indexOf(target);
        if (pos < 0) {
            return s;
        }
        int sLength = s.length();
        int targetLength = target.length();
        int searchSkip = Math.max(targetLength, 1);
        StringBuilder sb = new StringBuilder(sLength - targetLength + replacement.length());
        int prevPos = 0;
        do {
            sb.append(s, prevPos, pos);
            sb.append(replacement);
            prevPos = pos + targetLength;
        } while (pos != sLength && (pos = s.indexOf(target, pos + searchSkip)) > 0);
        sb.append(s, prevPos, sLength);
        return sb.toString();
    }

    public static String nullToEmptyNonDruidDataString(@Nullable String string) {
        return Strings.nullToEmpty((String)string);
    }

    @Nullable
    public static String emptyToNullNonDruidDataString(@Nullable String string) {
        return Strings.emptyToNull((String)string);
    }

    public static String utf8Base64(String input) {
        return StringUtils.fromUtf8(StringUtils.encodeBase64(StringUtils.toUtf8(input)));
    }

    public static byte[] encodeBase64(byte[] input) {
        return BASE64_ENCODER.encode(input);
    }

    public static String encodeBase64String(byte[] input) {
        return BASE64_ENCODER.encodeToString(input);
    }

    public static byte[] decodeBase64(byte[] input) {
        return BASE64_DECODER.decode(input);
    }

    public static byte[] decodeBase64String(String input) {
        return BASE64_DECODER.decode(input);
    }
}

