/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;

public class RetryUtils {
    public static final Logger log = new Logger(RetryUtils.class);
    public static final long MAX_SLEEP_MILLIS = 60000L;
    public static final long BASE_SLEEP_MILLIS = 1000L;

    public static <T> T retry(Task<T> f, Predicate<Throwable> shouldRetry, int quietTries, int maxTries, @Nullable CleanupAfterFailure cleanupAfterFailure, @Nullable String messageOnRetry) throws Exception {
        Preconditions.checkArgument((maxTries > 0 ? 1 : 0) != 0, (Object)"maxTries > 0");
        Preconditions.checkArgument((quietTries >= 0 ? 1 : 0) != 0, (Object)"quietTries >= 0");
        int nTry = 0;
        int maxRetries = maxTries - 1;
        while (true) {
            try {
                ++nTry;
                return f.perform();
            }
            catch (Throwable e) {
                if (cleanupAfterFailure != null) {
                    cleanupAfterFailure.cleanup();
                }
                if (nTry < maxTries && shouldRetry.apply((Object)e)) {
                    RetryUtils.awaitNextRetry(e, messageOnRetry, nTry, maxRetries, nTry <= quietTries);
                    continue;
                }
                Throwables.propagateIfInstanceOf((Throwable)e, Exception.class);
                throw Throwables.propagate((Throwable)e);
            }
            break;
        }
    }

    public static <T> T retry(Task<T> f, Predicate<Throwable> shouldRetry, int maxTries) throws Exception {
        return RetryUtils.retry(f, shouldRetry, 0, maxTries);
    }

    public static <T> T retry(Task<T> f, Predicate<Throwable> shouldRetry, int quietTries, int maxTries) throws Exception {
        return RetryUtils.retry(f, shouldRetry, quietTries, maxTries, null, null);
    }

    public static <T> T retry(Task<T> f, Predicate<Throwable> shouldRetry, CleanupAfterFailure onEachFailure, int maxTries, String messageOnRetry) throws Exception {
        return RetryUtils.retry(f, shouldRetry, 0, maxTries, onEachFailure, messageOnRetry);
    }

    public static void awaitNextRetry(Throwable e, @Nullable String messageOnRetry, int nTry, int maxRetries, boolean quiet) throws InterruptedException {
        long sleepMillis = RetryUtils.nextRetrySleepMillis(nTry);
        String fullMessage = messageOnRetry == null ? StringUtils.format("Retrying (%d of %d) in %,dms.", nTry, maxRetries, sleepMillis) : StringUtils.format("%s, retrying (%d of %d) in %,dms.", messageOnRetry, nTry, maxRetries, sleepMillis);
        if (quiet) {
            log.debug(e, fullMessage, new Object[0]);
        } else {
            log.warn(e, fullMessage, new Object[0]);
        }
        Thread.sleep(sleepMillis);
    }

    public static long nextRetrySleepMillis(int nTry) {
        double fuzzyMultiplier = Math.min(Math.max(1.0 + 0.2 * ThreadLocalRandom.current().nextGaussian(), 0.0), 2.0);
        long sleepMillis = (long)(Math.min(60000.0, 1000.0 * Math.pow(2.0, nTry - 1)) * fuzzyMultiplier);
        return sleepMillis;
    }

    public static interface CleanupAfterFailure {
        public void cleanup();
    }

    public static interface Task<T> {
        public T perform() throws Exception;
    }
}

