/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.NewSpatialDimensionSchema;
import org.apache.druid.data.input.impl.SpatialDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.java.util.common.parsers.ParserUtils;

public class DimensionsSpec {
    private final List<DimensionSchema> dimensions;
    private final Set<String> dimensionExclusions;
    private final Map<String, DimensionSchema> dimensionSchemaMap;
    public static final DimensionsSpec EMPTY = new DimensionsSpec(null, null, null);

    public static List<DimensionSchema> getDefaultSchemas(List<String> dimNames) {
        return DimensionsSpec.getDefaultSchemas(dimNames, DimensionSchema.MultiValueHandling.ofDefault());
    }

    public static List<DimensionSchema> getDefaultSchemas(List<String> dimNames, DimensionSchema.MultiValueHandling multiValueHandling) {
        return dimNames.stream().map(input -> new StringDimensionSchema((String)input, multiValueHandling, (Boolean)true)).collect(Collectors.toList());
    }

    public static DimensionSchema convertSpatialSchema(SpatialDimensionSchema spatialSchema) {
        return new NewSpatialDimensionSchema(spatialSchema.getDimName(), spatialSchema.getDims());
    }

    @JsonCreator
    public DimensionsSpec(@JsonProperty(value="dimensions") List<DimensionSchema> dimensions, @JsonProperty(value="dimensionExclusions") List<String> dimensionExclusions, @Deprecated @JsonProperty(value="spatialDimensions") List<SpatialDimensionSchema> spatialDimensions) {
        this.dimensions = dimensions == null ? new ArrayList<DimensionSchema>() : Lists.newArrayList(dimensions);
        this.dimensionExclusions = dimensionExclusions == null ? new HashSet<String>() : Sets.newHashSet(dimensionExclusions);
        ArrayList<SpatialDimensionSchema> spatialDims = spatialDimensions == null ? new ArrayList<SpatialDimensionSchema>() : spatialDimensions;
        this.verify(spatialDims);
        this.dimensionSchemaMap = new HashMap<String, DimensionSchema>();
        for (DimensionSchema schema : this.dimensions) {
            this.dimensionSchemaMap.put(schema.getName(), schema);
        }
        for (SpatialDimensionSchema spatialSchema : spatialDims) {
            DimensionSchema newSchema = DimensionsSpec.convertSpatialSchema(spatialSchema);
            this.dimensions.add(newSchema);
            this.dimensionSchemaMap.put(newSchema.getName(), newSchema);
        }
    }

    public DimensionsSpec(List<DimensionSchema> dimensions) {
        this(dimensions, null, null);
    }

    @JsonProperty
    public List<DimensionSchema> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty
    public Set<String> getDimensionExclusions() {
        return this.dimensionExclusions;
    }

    @Deprecated
    @JsonIgnore
    public List<SpatialDimensionSchema> getSpatialDimensions() {
        Iterable filteredList = Iterables.filter(this.dimensions, NewSpatialDimensionSchema.class);
        Iterable transformedList = Iterables.transform((Iterable)filteredList, (Function)new Function<NewSpatialDimensionSchema, SpatialDimensionSchema>(){

            @Nullable
            public SpatialDimensionSchema apply(NewSpatialDimensionSchema input) {
                return new SpatialDimensionSchema(input.getName(), input.getDims());
            }
        });
        return Lists.newArrayList((Iterable)transformedList);
    }

    @JsonIgnore
    public List<String> getDimensionNames() {
        return Lists.transform(this.dimensions, (Function)new Function<DimensionSchema, String>(){

            public String apply(DimensionSchema input) {
                return input.getName();
            }
        });
    }

    public DimensionSchema getSchema(String dimension) {
        return this.dimensionSchemaMap.get(dimension);
    }

    public boolean hasCustomDimensions() {
        return this.dimensions != null && !this.dimensions.isEmpty();
    }

    public DimensionsSpec withDimensions(List<DimensionSchema> dims) {
        return new DimensionsSpec(dims, (List<String>)ImmutableList.copyOf(this.dimensionExclusions), null);
    }

    public DimensionsSpec withDimensionExclusions(Set<String> dimExs) {
        return new DimensionsSpec(this.dimensions, (List<String>)ImmutableList.copyOf((Collection)Sets.union(this.dimensionExclusions, dimExs)), null);
    }

    @Deprecated
    public DimensionsSpec withSpatialDimensions(List<SpatialDimensionSchema> spatials) {
        return new DimensionsSpec(this.dimensions, (List<String>)ImmutableList.copyOf(this.dimensionExclusions), spatials);
    }

    private void verify(List<SpatialDimensionSchema> spatialDimensions) {
        List<String> dimNames = this.getDimensionNames();
        Preconditions.checkArgument((boolean)Sets.intersection(this.dimensionExclusions, (Set)Sets.newHashSet(dimNames)).isEmpty(), (Object)"dimensions and dimensions exclusions cannot overlap");
        ParserUtils.validateFields(dimNames);
        ParserUtils.validateFields(this.dimensionExclusions);
        List spatialDimNames = Lists.transform(spatialDimensions, (Function)new Function<SpatialDimensionSchema, String>(){

            public String apply(SpatialDimensionSchema input) {
                return input.getDimName();
            }
        });
        ParserUtils.validateFields(Iterables.concat(dimNames, (Iterable)spatialDimNames));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionsSpec that = (DimensionsSpec)o;
        if (!this.dimensions.equals(that.dimensions)) {
            return false;
        }
        return this.dimensionExclusions.equals(that.dimensionExclusions);
    }

    public int hashCode() {
        int result = this.dimensions.hashCode();
        result = 31 * result + this.dimensionExclusions.hashCode();
        return result;
    }

    public String toString() {
        return "DimensionsSpec{dimensions=" + this.dimensions + ", dimensionExclusions=" + this.dimensionExclusions + '}';
    }
}

