/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.druid.data.input.Firehose;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.impl.FileIteratingFirehose;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.java.util.common.logger.Logger;

public abstract class AbstractTextFilesFirehoseFactory<T>
implements FiniteFirehoseFactory<StringInputRowParser, T> {
    private static final Logger LOG = new Logger(AbstractTextFilesFirehoseFactory.class);
    private List<T> objects;

    @Override
    public Firehose connect(StringInputRowParser firehoseParser, File temporaryDirectory) throws IOException {
        this.initializeObjectsIfNeeded();
        final Iterator<T> iterator = this.objects.iterator();
        return new FileIteratingFirehose(new Iterator<LineIterator>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public LineIterator next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object object = iterator.next();
                try {
                    return IOUtils.lineIterator((InputStream)AbstractTextFilesFirehoseFactory.this.wrapObjectStream(object, AbstractTextFilesFirehoseFactory.this.openObjectStream(object)), (Charset)StandardCharsets.UTF_8);
                }
                catch (Exception e) {
                    LOG.error(e, "Exception reading object[%s]", object);
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }, firehoseParser);
    }

    protected void initializeObjectsIfNeeded() throws IOException {
        if (this.objects == null) {
            this.objects = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(this.initObjects(), (Object)"initObjects")));
        }
    }

    public List<T> getObjects() {
        return this.objects;
    }

    @Override
    public Stream<InputSplit<T>> getSplits() throws IOException {
        this.initializeObjectsIfNeeded();
        return this.getObjects().stream().map(InputSplit::new);
    }

    @Override
    public int getNumSplits() throws IOException {
        this.initializeObjectsIfNeeded();
        return this.getObjects().size();
    }

    protected abstract Collection<T> initObjects() throws IOException;

    protected abstract InputStream openObjectStream(T var1) throws IOException;

    protected abstract InputStream wrapObjectStream(T var1, InputStream var2) throws IOException;
}

