/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.Row;
import org.apache.druid.data.input.Rows;
import org.apache.druid.java.util.common.DateTimes;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class MapBasedRow
implements Row {
    private final DateTime timestamp;
    private final Map<String, Object> event;

    @JsonCreator
    public MapBasedRow(@JsonProperty(value="timestamp") DateTime timestamp, @JsonProperty(value="event") Map<String, Object> event) {
        this.timestamp = timestamp;
        this.event = event;
    }

    public MapBasedRow(long timestamp, Map<String, Object> event) {
        this(DateTimes.utc(timestamp), event);
    }

    @Override
    public long getTimestampFromEpoch() {
        return this.timestamp.getMillis();
    }

    @Override
    @JsonProperty
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty
    public Map<String, Object> getEvent() {
        return this.event;
    }

    @Override
    public List<String> getDimension(String dimension) {
        return Rows.objectToStrings(this.event.get(dimension));
    }

    @Override
    public Object getRaw(String dimension) {
        return this.event.get(dimension);
    }

    @Override
    public Number getMetric(String metric) {
        return Rows.objectToNumber(metric, this.event.get(metric));
    }

    public String toString() {
        return "MapBasedRow{timestamp=" + this.timestamp + ", event=" + this.event + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapBasedRow that = (MapBasedRow)o;
        if (!this.event.equals(that.event)) {
            return false;
        }
        return this.timestamp.equals((Object)that.timestamp);
    }

    public int hashCode() {
        int result = this.timestamp.hashCode();
        result = 31 * result + this.event.hashCode();
        return result;
    }

    @Override
    public int compareTo(Row o) {
        return this.timestamp.compareTo((ReadableInstant)o.getTimestamp());
    }
}

