/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.utils;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.java.util.common.ISE;

public class SocketUtil {
    public static int findOpenPort(int basePort) {
        int startPort = basePort < 0 ? -1 : ThreadLocalRandom.current().nextInt(Short.MAX_VALUE) + basePort;
        return SocketUtil.findOpenPortFrom(startPort);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int findOpenPortFrom(int startPort) {
        int currPort = startPort;
        while (true) {
            if (currPort >= 65535) {
                throw new ISE("Unable to find open port between [%d] and [%d]", startPort, currPort);
            }
            try (ServerSocket socket = new ServerSocket(currPort);){
                int n = currPort;
                return n;
            }
            catch (IOException e) {
                ++currPort;
                continue;
            }
            break;
        }
    }
}

