/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.config;

import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.common.config.ConfigManagerConfig;
import org.apache.druid.common.config.ConfigSerde;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.joda.time.Duration;

public class ConfigManager {
    private static final Logger log = new Logger(ConfigManager.class);
    private final Object lock = new Object();
    private boolean started = false;
    private final MetadataStorageConnector dbConnector;
    private final Supplier<ConfigManagerConfig> config;
    private final ScheduledExecutorService exec;
    private final ConcurrentMap<String, ConfigHolder> watchedConfigs;
    private final String configTable;
    private volatile PollingCallable poller;

    @Inject
    public ConfigManager(MetadataStorageConnector dbConnector, Supplier<MetadataStorageTablesConfig> dbTables, Supplier<ConfigManagerConfig> config) {
        this.dbConnector = dbConnector;
        this.config = config;
        this.exec = ScheduledExecutors.fixed(1, "config-manager-%s");
        this.watchedConfigs = new ConcurrentHashMap<String, ConfigHolder>();
        this.configTable = ((MetadataStorageTablesConfig)dbTables.get()).getConfigTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.poller = new PollingCallable();
            ScheduledExecutors.scheduleWithFixedDelay(this.exec, new Duration(0L), ((ConfigManagerConfig)this.config.get()).getPollDuration().toStandardDuration(), this.poller);
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.poller.stop();
            this.poller = null;
            this.started = false;
        }
    }

    private void poll() {
        for (Map.Entry entry : this.watchedConfigs.entrySet()) {
            try {
                if (!((ConfigHolder)entry.getValue()).swapIfNew(this.dbConnector.lookup(this.configTable, "name", "payload", (String)entry.getKey()))) continue;
                log.info("New value for key[%s] seen.", entry.getKey());
            }
            catch (Exception e) {
                log.warn(e, "Exception when checking property[%s]", entry.getKey());
            }
        }
    }

    public <T> AtomicReference<T> watchConfig(final String key, final ConfigSerde<T> serde) {
        ConfigHolder holder = (ConfigHolder)this.watchedConfigs.get(key);
        if (holder == null) {
            try {
                log.info("Creating watch for key[%s]", key);
                holder = (ConfigHolder)this.exec.submit(new Callable<ConfigHolder<T>>(){

                    @Override
                    public ConfigHolder<T> call() {
                        if (!ConfigManager.this.started) {
                            ConfigManager.this.watchedConfigs.put(key, new ConfigHolder(null, serde));
                        } else {
                            try {
                                if (!ConfigManager.this.watchedConfigs.containsKey(key)) {
                                    byte[] value = ConfigManager.this.dbConnector.lookup(ConfigManager.this.configTable, "name", "payload", key);
                                    ConfigHolder holder = new ConfigHolder(value, serde);
                                    ConfigManager.this.watchedConfigs.put(key, holder);
                                }
                            }
                            catch (Exception e) {
                                log.warn(e, "Failed loading config for key[%s]", key);
                                ConfigManager.this.watchedConfigs.put(key, new ConfigHolder(null, serde));
                            }
                        }
                        return (ConfigHolder)ConfigManager.this.watchedConfigs.get(key);
                    }
                }).get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
            catch (ExecutionException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return holder.getReference();
    }

    public <T> SetResult set(String key, ConfigSerde<T> serde, T obj) {
        if (obj == null || !this.started) {
            if (obj == null) {
                return SetResult.fail(new IllegalAccessException("input obj is null"));
            }
            return SetResult.fail(new IllegalStateException("configManager is not started yet"));
        }
        byte[] newBytes = serde.serialize(obj);
        try {
            this.exec.submit(() -> {
                this.dbConnector.insertOrUpdate(this.configTable, "name", "payload", key, newBytes);
                ConfigHolder configHolder = (ConfigHolder)this.watchedConfigs.get(key);
                if (configHolder != null) {
                    configHolder.swapIfNew(newBytes);
                }
                return true;
            }).get();
            return SetResult.ok();
        }
        catch (Exception e) {
            log.warn(e, "Failed to set[%s]", key);
            return SetResult.fail(e);
        }
    }

    private class PollingCallable
    implements Callable<ScheduledExecutors.Signal> {
        private volatile boolean stop = false;

        private PollingCallable() {
        }

        void stop() {
            this.stop = true;
        }

        @Override
        public ScheduledExecutors.Signal call() {
            if (this.stop) {
                return ScheduledExecutors.Signal.STOP;
            }
            ConfigManager.this.poll();
            return ScheduledExecutors.Signal.REPEAT;
        }
    }

    private static class ConfigHolder<T> {
        private final AtomicReference<byte[]> rawBytes;
        private final ConfigSerde<T> serde;
        private final AtomicReference<T> reference;

        ConfigHolder(byte[] rawBytes, ConfigSerde<T> serde) {
            this.rawBytes = new AtomicReference<byte[]>(rawBytes);
            this.serde = serde;
            this.reference = new AtomicReference<T>(serde.deserialize(rawBytes));
        }

        public AtomicReference<T> getReference() {
            return this.reference;
        }

        public boolean swapIfNew(byte[] newBytes) {
            if (!Arrays.equals(newBytes, this.rawBytes.get())) {
                this.reference.set(this.serde.deserialize(newBytes));
                this.rawBytes.set(newBytes);
                return true;
            }
            return false;
        }
    }

    public static class SetResult {
        private final Exception exception;

        public static SetResult ok() {
            return new SetResult(null);
        }

        public static SetResult fail(Exception e) {
            return new SetResult(e);
        }

        private SetResult(@Nullable Exception exception) {
            this.exception = exception;
        }

        public boolean isOk() {
            return this.exception == null;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

