/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.druid.segment.column;

import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ReadableOffset;

import javax.annotation.Nullable;

/**
 */
public interface DictionaryEncodedColumn<ActualType extends Comparable<? super ActualType>> extends BaseColumn
{
  int length();
  boolean hasMultipleValues();
  int getSingleValueRow(int rowNum);
  IndexedInts getMultiValueRow(int rowNum);
  ActualType lookupName(int id);
  int lookupId(ActualType name);
  int getCardinality();

  DimensionSelector makeDimensionSelector(ReadableOffset offset, @Nullable ExtractionFn extractionFn);

  @Override
  default ColumnValueSelector<?> makeColumnValueSelector(ReadableOffset offset)
  {
    return makeDimensionSelector(offset, null);
  }
}
