<!--
  ~ Licensed to the Apache Software Foundation (ASF) under one
  ~ or more contributor license agreements.  See the NOTICE file
  ~ distributed with this work for additional information
  ~ regarding copyright ownership.  The ASF licenses this file
  ~ to you under the Apache License, Version 2.0 (the
  ~ "License"); you may not use this file except in compliance
  ~ with the License.  You may obtain a copy of the License at
  ~
  ~   http://www.apache.org/licenses/LICENSE-2.0
  ~
  ~ Unless required by applicable law or agreed to in writing,
  ~ software distributed under the License is distributed on an
  ~ "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  ~ KIND, either express or implied.  See the License for the
  ~ specific language governing permissions and limitations
  ~ under the License.
  -->

[![Build Status](https://travis-ci.org/apache/incubator-druid.svg?branch=master)](https://travis-ci.org/apache/incubator-druid) [![Inspections Status](https://img.shields.io/teamcity/http/teamcity.jetbrains.com/s/OpenSourceProjects_Druid_Inspections.svg?label=TeamCity%20inspections)](https://teamcity.jetbrains.com/viewType.html?buildTypeId=OpenSourceProjects_Druid_Inspections) [![Coverage Status](https://coveralls.io/repos/apache/incubator-druid/badge.svg?branch=master)](https://coveralls.io/r/apache/incubator-druid?branch=master) [![IRC#druid-dev](https://img.shields.io/badge/IRC-druid--dev-blue.svg)](https://webchat.freenode.net?channels=druid-dev)

## Apache Druid (incubating)

Apache Druid (incubating) is a high performance analytics data store for event-driven data.

*Disclaimer: Apache Druid is an effort undergoing incubation at The Apache Software Foundation (ASF), sponsored by the Apache Incubator. Incubation is required of all newly accepted projects until a further review indicates that the infrastructure, communications, and decision making process have stabilized in a manner consistent with other successful ASF projects. While incubation status is not necessarily a reflection of the completeness or stability of the code, it does indicate that the project has yet to be fully endorsed by the ASF.*

### License

[Apache License, Version 2.0](http://www.apache.org/licenses/LICENSE-2.0)

### More Information

More information about Druid can be found on <http://www.druid.io>.

### Documentation

You can find the [documentation for the latest Druid release](http://druid.io/docs/latest/) on
the [project website](http://druid.io/docs/latest/).

If you would like to contribute documentation, please do so under
`/docs/content` in this repository and submit a pull request.

### Getting Started

You can get started with Druid with our [quickstart](http://druid.io/docs/latest/tutorials/quickstart.html).

### Reporting Issues

If you find any bugs, please file a [GitHub issue](https://github.com/apache/incubator-druid/issues).

### Community

The Druid community is in the process of migrating to Apache by way of the Apache Incubator. Eventually, as we proceed
along this path, our site will move from http://druid.io/ to https://druid.apache.org/.

Community support is available on the
[druid-user mailing list](https://groups.google.com/forum/#!forum/druid-user)(druid-user@googlegroups.com), which
is hosted at Google Groups.

Development discussions occur on [dev@druid.apache.org](https://lists.apache.org/list.html?dev@druid.apache.org), which
you can subscribe to by emailing [dev-subscribe@druid.apache.org](mailto:dev-subscribe@druid.apache.org).

We also have a couple people hanging out on IRC in `#druid-dev` on
`irc.freenode.net`.

### Building From Source

Please note that JDK 8 is required to build Druid.

For instructions on building Druid from source, see [docs/content/development/build.md](https://github.com/apache/incubator-druid/blob/0.14.0-incubating/docs/content/development/build.md)

### Contributing

Please follow the guidelines listed [here](http://druid.io/community/).

