/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.metadata;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.categories.RowSetTests;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.ColumnBuilder;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.DictColumnMetadata;
import org.apache.drill.exec.record.metadata.MapColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.PrimitiveColumnMetadata;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.record.metadata.TupleSchema;
import org.apache.drill.exec.record.metadata.VariantColumnMetadata;
import org.apache.drill.exec.record.metadata.VariantMetadata;
import org.apache.drill.test.BaseTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RowSetTests.class})
public class TestTupleSchema
extends BaseTest {
    @Test
    public void testRequiredFixedWidthColumn() {
        MaterializedField field = SchemaBuilder.columnSchema((String)"c", (TypeProtos.MinorType)TypeProtos.MinorType.INT, (TypeProtos.DataMode)TypeProtos.DataMode.REQUIRED);
        ColumnMetadata col = MetadataUtils.fromField((MaterializedField)field);
        Assert.assertTrue((boolean)(col instanceof PrimitiveColumnMetadata));
        Assert.assertEquals((Object)ColumnMetadata.StructureType.PRIMITIVE, (Object)col.structureType());
        Assert.assertNull((Object)col.tupleSchema());
        Assert.assertTrue((boolean)field.isEquivalent(col.schema()));
        Assert.assertEquals((Object)field.getName(), (Object)col.name());
        Assert.assertEquals((Object)field.getType().getMinorType(), (Object)col.type());
        Assert.assertEquals((Object)field.getDataMode(), (Object)col.mode());
        Assert.assertFalse((boolean)col.isNullable());
        Assert.assertFalse((boolean)col.isArray());
        Assert.assertFalse((boolean)col.isVariableWidth());
        Assert.assertFalse((boolean)col.isMap());
        Assert.assertTrue((boolean)col.isEquivalent(col));
        Assert.assertFalse((boolean)col.isVariant());
        ColumnMetadata col2 = MetadataUtils.fromField((MaterializedField)field);
        Assert.assertTrue((boolean)col.isEquivalent(col2));
        MaterializedField field3 = SchemaBuilder.columnSchema((String)"d", (TypeProtos.MinorType)TypeProtos.MinorType.INT, (TypeProtos.DataMode)TypeProtos.DataMode.REQUIRED);
        ColumnMetadata col3 = MetadataUtils.fromField((MaterializedField)field3);
        Assert.assertFalse((boolean)col.isEquivalent(col3));
        MaterializedField field4 = SchemaBuilder.columnSchema((String)"c", (TypeProtos.MinorType)TypeProtos.MinorType.BIGINT, (TypeProtos.DataMode)TypeProtos.DataMode.REQUIRED);
        ColumnMetadata col4 = MetadataUtils.fromField((MaterializedField)field4);
        Assert.assertFalse((boolean)col.isEquivalent(col4));
        MaterializedField field5 = SchemaBuilder.columnSchema((String)"c", (TypeProtos.MinorType)TypeProtos.MinorType.INT, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
        ColumnMetadata col5 = MetadataUtils.fromField((MaterializedField)field5);
        Assert.assertFalse((boolean)col.isEquivalent(col5));
        ColumnMetadata col6 = col.cloneEmpty();
        Assert.assertTrue((boolean)col.isEquivalent(col6));
        Assert.assertEquals((long)4L, (long)col.expectedWidth());
        col.setExpectedWidth(10);
        Assert.assertEquals((long)4L, (long)col.expectedWidth());
        Assert.assertEquals((long)1L, (long)col.expectedElementCount());
        col.setExpectedElementCount(2);
        Assert.assertEquals((long)1L, (long)col.expectedElementCount());
    }

    @Test
    public void testNullableFixedWidthColumn() {
        MaterializedField field = SchemaBuilder.columnSchema((String)"c", (TypeProtos.MinorType)TypeProtos.MinorType.INT, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
        ColumnMetadata col = MetadataUtils.fromField((MaterializedField)field);
        Assert.assertEquals((Object)ColumnMetadata.StructureType.PRIMITIVE, (Object)col.structureType());
        Assert.assertTrue((boolean)col.isNullable());
        Assert.assertFalse((boolean)col.isArray());
        Assert.assertFalse((boolean)col.isVariableWidth());
        Assert.assertFalse((boolean)col.isMap());
        Assert.assertFalse((boolean)col.isVariant());
        Assert.assertEquals((long)4L, (long)col.expectedWidth());
        col.setExpectedWidth(10);
        Assert.assertEquals((long)4L, (long)col.expectedWidth());
        Assert.assertEquals((long)1L, (long)col.expectedElementCount());
        col.setExpectedElementCount(2);
        Assert.assertEquals((long)1L, (long)col.expectedElementCount());
    }

    @Test
    public void testRepeatedFixedWidthColumn() {
        MaterializedField field = SchemaBuilder.columnSchema((String)"c", (TypeProtos.MinorType)TypeProtos.MinorType.INT, (TypeProtos.DataMode)TypeProtos.DataMode.REPEATED);
        ColumnMetadata col = MetadataUtils.fromField((MaterializedField)field);
        Assert.assertFalse((boolean)col.isNullable());
        Assert.assertTrue((boolean)col.isArray());
        Assert.assertFalse((boolean)col.isVariableWidth());
        Assert.assertFalse((boolean)col.isMap());
        Assert.assertFalse((boolean)col.isVariant());
        Assert.assertEquals((long)4L, (long)col.expectedWidth());
        col.setExpectedWidth(10);
        Assert.assertEquals((long)4L, (long)col.expectedWidth());
        Assert.assertEquals((long)10L, (long)col.expectedElementCount());
        col.setExpectedElementCount(2);
        Assert.assertEquals((long)2L, (long)col.expectedElementCount());
        col.setExpectedElementCount(0);
        Assert.assertEquals((long)1L, (long)col.expectedElementCount());
    }

    @Test
    public void testRequiredVariableWidthColumn() {
        MaterializedField field = SchemaBuilder.columnSchema((String)"c", (TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR, (TypeProtos.DataMode)TypeProtos.DataMode.REQUIRED);
        ColumnMetadata col = MetadataUtils.fromField((MaterializedField)field);
        Assert.assertEquals((Object)ColumnMetadata.StructureType.PRIMITIVE, (Object)col.structureType());
        Assert.assertNull((Object)col.tupleSchema());
        Assert.assertFalse((boolean)col.isNullable());
        Assert.assertFalse((boolean)col.isArray());
        Assert.assertTrue((boolean)col.isVariableWidth());
        Assert.assertFalse((boolean)col.isMap());
        Assert.assertFalse((boolean)col.isVariant());
        MaterializedField field2 = new ColumnBuilder("c", TypeProtos.MinorType.VARCHAR).setMode(TypeProtos.DataMode.REQUIRED).setPrecision(10).build();
        ColumnMetadata col2 = MetadataUtils.fromField((MaterializedField)field2);
        Assert.assertFalse((boolean)col.isEquivalent(col2));
        Assert.assertEquals((long)50L, (long)col.expectedWidth());
        col.setExpectedWidth(10);
        Assert.assertEquals((long)10L, (long)col.expectedWidth());
        Assert.assertEquals((long)1L, (long)col.expectedElementCount());
        col.setExpectedElementCount(2);
        Assert.assertEquals((long)1L, (long)col.expectedElementCount());
        col = MetadataUtils.fromField((MaterializedField)field2);
        Assert.assertEquals((long)10L, (long)col.expectedWidth());
    }

    @Test
    public void testNullableVariableWidthColumn() {
        MaterializedField field = SchemaBuilder.columnSchema((String)"c", (TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
        ColumnMetadata col = MetadataUtils.fromField((MaterializedField)field);
        Assert.assertTrue((boolean)col.isNullable());
        Assert.assertFalse((boolean)col.isArray());
        Assert.assertTrue((boolean)col.isVariableWidth());
        Assert.assertFalse((boolean)col.isMap());
        Assert.assertFalse((boolean)col.isVariant());
        Assert.assertEquals((long)50L, (long)col.expectedWidth());
        col.setExpectedWidth(10);
        Assert.assertEquals((long)10L, (long)col.expectedWidth());
        Assert.assertEquals((long)1L, (long)col.expectedElementCount());
        col.setExpectedElementCount(2);
        Assert.assertEquals((long)1L, (long)col.expectedElementCount());
    }

    @Test
    public void testRepeatedVariableWidthColumn() {
        MaterializedField field = SchemaBuilder.columnSchema((String)"c", (TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR, (TypeProtos.DataMode)TypeProtos.DataMode.REPEATED);
        ColumnMetadata col = MetadataUtils.fromField((MaterializedField)field);
        Assert.assertFalse((boolean)col.isNullable());
        Assert.assertTrue((boolean)col.isArray());
        Assert.assertTrue((boolean)col.isVariableWidth());
        Assert.assertFalse((boolean)col.isMap());
        Assert.assertFalse((boolean)col.isVariant());
        Assert.assertEquals((long)50L, (long)col.expectedWidth());
        col.setExpectedWidth(10);
        Assert.assertEquals((long)10L, (long)col.expectedWidth());
        Assert.assertEquals((long)10L, (long)col.expectedElementCount());
        col.setExpectedElementCount(2);
        Assert.assertEquals((long)2L, (long)col.expectedElementCount());
    }

    @Test
    public void testDecimalScalePrecision() {
        MaterializedField field = MaterializedField.create((String)"d", (TypeProtos.MajorType)TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.DECIMAL9).setMode(TypeProtos.DataMode.REQUIRED).setPrecision(3).setScale(4).build());
        ColumnMetadata col = MetadataUtils.fromField((MaterializedField)field);
        Assert.assertFalse((boolean)col.isNullable());
        Assert.assertFalse((boolean)col.isArray());
        Assert.assertFalse((boolean)col.isVariableWidth());
        Assert.assertFalse((boolean)col.isMap());
        Assert.assertFalse((boolean)col.isVariant());
        Assert.assertEquals((long)3L, (long)col.precision());
        Assert.assertEquals((long)4L, (long)col.scale());
        Assert.assertTrue((boolean)field.isEquivalent(col.schema()));
    }

    @Test
    public void testMapColumn() {
        MaterializedField field = SchemaBuilder.columnSchema((String)"m", (TypeProtos.MinorType)TypeProtos.MinorType.MAP, (TypeProtos.DataMode)TypeProtos.DataMode.REQUIRED);
        ColumnMetadata col = MetadataUtils.fromField((MaterializedField)field);
        Assert.assertTrue((boolean)(col instanceof MapColumnMetadata));
        Assert.assertNotNull((Object)col.tupleSchema());
        Assert.assertEquals((long)0L, (long)col.tupleSchema().size());
        Assert.assertSame((Object)col, (Object)col.tupleSchema().parent());
        MapColumnMetadata mapCol = (MapColumnMetadata)col;
        Assert.assertNull((Object)mapCol.parentTuple());
        Assert.assertEquals((Object)ColumnMetadata.StructureType.TUPLE, (Object)col.structureType());
        Assert.assertFalse((boolean)col.isNullable());
        Assert.assertFalse((boolean)col.isArray());
        Assert.assertFalse((boolean)col.isVariableWidth());
        Assert.assertTrue((boolean)col.isMap());
        Assert.assertFalse((boolean)col.isVariant());
        Assert.assertEquals((long)0L, (long)col.expectedWidth());
        col.setExpectedWidth(10);
        Assert.assertEquals((long)0L, (long)col.expectedWidth());
        Assert.assertEquals((long)1L, (long)col.expectedElementCount());
        col.setExpectedElementCount(2);
        Assert.assertEquals((long)1L, (long)col.expectedElementCount());
    }

    @Test
    public void testRepeatedMapColumn() {
        MaterializedField field = SchemaBuilder.columnSchema((String)"m", (TypeProtos.MinorType)TypeProtos.MinorType.MAP, (TypeProtos.DataMode)TypeProtos.DataMode.REPEATED);
        ColumnMetadata col = MetadataUtils.fromField((MaterializedField)field);
        Assert.assertTrue((boolean)(col instanceof MapColumnMetadata));
        Assert.assertNotNull((Object)col.tupleSchema());
        Assert.assertEquals((long)0L, (long)col.tupleSchema().size());
        Assert.assertFalse((boolean)col.isNullable());
        Assert.assertTrue((boolean)col.isArray());
        Assert.assertFalse((boolean)col.isVariableWidth());
        Assert.assertTrue((boolean)col.isMap());
        Assert.assertFalse((boolean)col.isVariant());
        Assert.assertEquals((long)0L, (long)col.expectedWidth());
        col.setExpectedWidth(10);
        Assert.assertEquals((long)0L, (long)col.expectedWidth());
        Assert.assertEquals((long)10L, (long)col.expectedElementCount());
        col.setExpectedElementCount(2);
        Assert.assertEquals((long)2L, (long)col.expectedElementCount());
    }

    @Test
    public void testUnionColumn() {
        MaterializedField field = SchemaBuilder.columnSchema((String)"u", (TypeProtos.MinorType)TypeProtos.MinorType.UNION, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
        ColumnMetadata col = MetadataUtils.fromField((MaterializedField)field);
        Assert.assertFalse((boolean)col.isArray());
        Assert.assertTrue((boolean)col.isVariableWidth());
        this.doVariantTest(col);
    }

    @Test
    public void testListColumn() {
        MaterializedField field = SchemaBuilder.columnSchema((String)"l", (TypeProtos.MinorType)TypeProtos.MinorType.LIST, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
        ColumnMetadata col = MetadataUtils.fromField((MaterializedField)field);
        Assert.assertTrue((boolean)col.isArray());
        Assert.assertFalse((boolean)col.isVariableWidth());
        this.doVariantTest(col);
    }

    private void doVariantTest(ColumnMetadata col) {
        Assert.assertTrue((boolean)(col instanceof VariantColumnMetadata));
        Assert.assertTrue((boolean)col.isNullable());
        Assert.assertFalse((boolean)col.isMap());
        Assert.assertTrue((boolean)col.isVariant());
        Assert.assertEquals((long)0L, (long)col.expectedWidth());
        col.setExpectedWidth(10);
        Assert.assertEquals((long)0L, (long)col.expectedWidth());
        VariantMetadata variant = col.variantSchema();
        Assert.assertNotNull((Object)variant);
        Assert.assertEquals((long)0L, (long)variant.size());
        ColumnMetadata member = variant.addType(TypeProtos.MinorType.INT);
        Assert.assertEquals((Object)TypeProtos.MinorType.INT, (Object)member.type());
        Assert.assertEquals((Object)TypeProtos.DataMode.OPTIONAL, (Object)member.mode());
        Assert.assertEquals((Object)Types.typeKey((TypeProtos.MinorType)TypeProtos.MinorType.INT), (Object)member.name());
        Assert.assertEquals((long)1L, (long)variant.size());
        Assert.assertTrue((boolean)variant.hasType(TypeProtos.MinorType.INT));
        Assert.assertSame((Object)member, (Object)variant.member(TypeProtos.MinorType.INT));
        try {
            variant.addType(TypeProtos.MinorType.INT);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)variant.hasType(TypeProtos.MinorType.VARCHAR));
        member = variant.addType(TypeProtos.MinorType.VARCHAR);
        Assert.assertEquals((Object)TypeProtos.MinorType.VARCHAR, (Object)member.type());
        Assert.assertEquals((Object)TypeProtos.DataMode.OPTIONAL, (Object)member.mode());
        Assert.assertEquals((Object)Types.typeKey((TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR), (Object)member.name());
        Assert.assertEquals((long)2L, (long)variant.size());
        Assert.assertTrue((boolean)variant.hasType(TypeProtos.MinorType.VARCHAR));
        Assert.assertSame((Object)member, (Object)variant.member(TypeProtos.MinorType.VARCHAR));
        Assert.assertFalse((boolean)variant.hasType(TypeProtos.MinorType.BIGINT));
    }

    @Test
    public void testEmptyRootTuple() {
        TupleSchema root = new TupleSchema();
        Assert.assertEquals((long)0L, (long)root.size());
        Assert.assertTrue((boolean)root.isEmpty());
        Assert.assertEquals((long)-1L, (long)root.index("foo"));
        try {
            root.metadata(0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertNull((Object)root.metadata("foo"));
        try {
            root.column(0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertNull((Object)root.column("foo"));
        try {
            root.fullName(0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        MaterializedField field = SchemaBuilder.columnSchema((String)"c", (TypeProtos.MinorType)TypeProtos.MinorType.INT, (TypeProtos.DataMode)TypeProtos.DataMode.REQUIRED);
        ColumnMetadata col = MetadataUtils.fromField((MaterializedField)field);
        Assert.assertEquals((Object)"c", (Object)root.fullName(col));
        Assert.assertTrue((boolean)root.isEquivalent((TupleMetadata)root));
        Assert.assertNull((Object)root.parent());
        Assert.assertTrue((boolean)root.toFieldList().isEmpty());
    }

    @Test
    public void testNonEmptyRootTuple() {
        TupleSchema root = new TupleSchema();
        MaterializedField fieldA = SchemaBuilder.columnSchema((String)"a", (TypeProtos.MinorType)TypeProtos.MinorType.INT, (TypeProtos.DataMode)TypeProtos.DataMode.REQUIRED);
        ColumnMetadata colA = root.add(fieldA);
        Assert.assertEquals((long)1L, (long)root.size());
        Assert.assertFalse((boolean)root.isEmpty());
        Assert.assertEquals((long)0L, (long)root.index("a"));
        Assert.assertEquals((long)-1L, (long)root.index("b"));
        Assert.assertTrue((boolean)fieldA.isEquivalent(root.column(0)));
        Assert.assertTrue((boolean)fieldA.isEquivalent(root.column("a")));
        Assert.assertTrue((boolean)fieldA.isEquivalent(root.column("A")));
        Assert.assertSame((Object)colA, (Object)root.metadata(0));
        Assert.assertSame((Object)colA, (Object)root.metadata("a"));
        Assert.assertEquals((Object)"a", (Object)root.fullName(0));
        Assert.assertEquals((Object)"a", (Object)root.fullName(colA));
        try {
            root.add(fieldA);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        MaterializedField fieldB = SchemaBuilder.columnSchema((String)"b", (TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR, (TypeProtos.DataMode)TypeProtos.DataMode.OPTIONAL);
        ColumnMetadata colB = MetadataUtils.fromField((MaterializedField)fieldB);
        int indexB = root.addColumn(colB);
        Assert.assertEquals((long)1L, (long)indexB);
        Assert.assertEquals((long)2L, (long)root.size());
        Assert.assertFalse((boolean)root.isEmpty());
        Assert.assertEquals((long)indexB, (long)root.index("b"));
        Assert.assertTrue((boolean)fieldB.isEquivalent(root.column(1)));
        Assert.assertTrue((boolean)fieldB.isEquivalent(root.column("b")));
        Assert.assertSame((Object)colB, (Object)root.metadata(1));
        Assert.assertSame((Object)colB, (Object)root.metadata("b"));
        Assert.assertEquals((Object)"b", (Object)root.fullName(1));
        Assert.assertEquals((Object)"b", (Object)root.fullName(colB));
        try {
            root.add(fieldB);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        List fieldList = root.toFieldList();
        Assert.assertTrue((boolean)fieldA.isEquivalent((MaterializedField)fieldList.get(0)));
        Assert.assertTrue((boolean)fieldB.isEquivalent((MaterializedField)fieldList.get(1)));
        TupleSchema emptyRoot = new TupleSchema();
        Assert.assertFalse((boolean)emptyRoot.isEquivalent((TupleMetadata)root));
        TupleSchema root3 = new TupleSchema();
        root3.add(fieldA);
        root3.addColumn(colB);
        Assert.assertTrue((boolean)root3.isEquivalent((TupleMetadata)root));
        Assert.assertTrue((boolean)root.isEquivalent((TupleMetadata)root3));
        TupleSchema root4 = new TupleSchema();
        root4.addColumn(colB);
        root4.add(fieldA);
        Assert.assertFalse((boolean)root4.isEquivalent((TupleMetadata)root));
        Assert.assertFalse((boolean)root.isEquivalent((TupleMetadata)root4));
        Assert.assertTrue((boolean)root.isEquivalent((TupleMetadata)root.copy()));
    }

    @Test
    public void testMapTupleFromMetadata() {
        TupleSchema root = new TupleSchema();
        MaterializedField fieldA = SchemaBuilder.columnSchema((String)"a", (TypeProtos.MinorType)TypeProtos.MinorType.MAP, (TypeProtos.DataMode)TypeProtos.DataMode.REQUIRED);
        ColumnMetadata colA = root.add(fieldA);
        TupleMetadata mapA = colA.tupleSchema();
        MaterializedField fieldB = SchemaBuilder.columnSchema((String)"b.x", (TypeProtos.MinorType)TypeProtos.MinorType.MAP, (TypeProtos.DataMode)TypeProtos.DataMode.REQUIRED);
        ColumnMetadata colB = mapA.add(fieldB);
        TupleMetadata mapB = colB.tupleSchema();
        MaterializedField fieldC = SchemaBuilder.columnSchema((String)"c.y", (TypeProtos.MinorType)TypeProtos.MinorType.MAP, (TypeProtos.DataMode)TypeProtos.DataMode.REQUIRED);
        ColumnMetadata colC = mapB.add(fieldC);
        TupleMetadata mapC = colC.tupleSchema();
        MaterializedField fieldD = SchemaBuilder.columnSchema((String)"d", (TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR, (TypeProtos.DataMode)TypeProtos.DataMode.REQUIRED);
        ColumnMetadata colD = mapC.add(fieldD);
        MaterializedField fieldE = SchemaBuilder.columnSchema((String)"e", (TypeProtos.MinorType)TypeProtos.MinorType.INT, (TypeProtos.DataMode)TypeProtos.DataMode.REQUIRED);
        ColumnMetadata colE = mapC.add(fieldE);
        Assert.assertEquals((long)1L, (long)root.size());
        Assert.assertEquals((long)1L, (long)mapA.size());
        Assert.assertEquals((long)1L, (long)mapB.size());
        Assert.assertEquals((long)2L, (long)mapC.size());
        Assert.assertSame((Object)colA, (Object)root.metadata("a"));
        Assert.assertSame((Object)colB, (Object)mapA.metadata("b.x"));
        Assert.assertSame((Object)colC, (Object)mapB.metadata("c.y"));
        Assert.assertSame((Object)colD, (Object)mapC.metadata("d"));
        Assert.assertSame((Object)colE, (Object)mapC.metadata("e"));
        Assert.assertEquals((Object)"a", (Object)root.fullName(0));
        Assert.assertEquals((Object)"a.`b.x`", (Object)mapA.fullName(0));
        Assert.assertEquals((Object)"a.`b.x`.`c.y`", (Object)mapB.fullName(0));
        Assert.assertEquals((Object)"a.`b.x`.`c.y`.d", (Object)mapC.fullName(0));
        Assert.assertEquals((Object)"a.`b.x`.`c.y`.e", (Object)mapC.fullName(1));
        Assert.assertEquals((long)1L, (long)colA.schema().getChildren().size());
        Assert.assertEquals((long)1L, (long)colB.schema().getChildren().size());
        Assert.assertEquals((long)2L, (long)colC.schema().getChildren().size());
        Iterator iterC = colC.schema().getChildren().iterator();
        Assert.assertTrue((boolean)fieldD.isEquivalent((MaterializedField)iterC.next()));
        Assert.assertTrue((boolean)fieldE.isEquivalent((MaterializedField)iterC.next()));
        TupleSchema root2 = root.copy();
        Assert.assertEquals((long)2L, (long)root2.metadata(0).tupleSchema().metadata(0).tupleSchema().metadata(0).tupleSchema().size());
        assert (root.isEquivalent((TupleMetadata)root2));
        fieldA.addChild(fieldB);
        fieldB.addChild(fieldC);
        fieldC.addChild(fieldD);
        fieldC.addChild(fieldE);
        Assert.assertTrue((boolean)colA.schema().isEquivalent(fieldA));
    }

    @Test
    public void testMapTupleFromField() {
        MaterializedField fieldA = SchemaBuilder.columnSchema((String)"a", (TypeProtos.MinorType)TypeProtos.MinorType.MAP, (TypeProtos.DataMode)TypeProtos.DataMode.REQUIRED);
        MaterializedField fieldB = SchemaBuilder.columnSchema((String)"b.x", (TypeProtos.MinorType)TypeProtos.MinorType.MAP, (TypeProtos.DataMode)TypeProtos.DataMode.REQUIRED);
        fieldA.addChild(fieldB);
        MaterializedField fieldC = SchemaBuilder.columnSchema((String)"c.y", (TypeProtos.MinorType)TypeProtos.MinorType.MAP, (TypeProtos.DataMode)TypeProtos.DataMode.REQUIRED);
        fieldB.addChild(fieldC);
        MaterializedField fieldD = SchemaBuilder.columnSchema((String)"d", (TypeProtos.MinorType)TypeProtos.MinorType.VARCHAR, (TypeProtos.DataMode)TypeProtos.DataMode.REQUIRED);
        fieldC.addChild(fieldD);
        MaterializedField fieldE = SchemaBuilder.columnSchema((String)"e", (TypeProtos.MinorType)TypeProtos.MinorType.INT, (TypeProtos.DataMode)TypeProtos.DataMode.REQUIRED);
        fieldC.addChild(fieldE);
        TupleSchema root = new TupleSchema();
        ColumnMetadata colA = root.add(fieldA);
        TupleMetadata mapA = colA.tupleSchema();
        ColumnMetadata colB = mapA.metadata("b.x");
        TupleMetadata mapB = colB.tupleSchema();
        ColumnMetadata colC = mapB.metadata("c.y");
        TupleMetadata mapC = colC.tupleSchema();
        ColumnMetadata colD = mapC.metadata("d");
        ColumnMetadata colE = mapC.metadata("e");
        Assert.assertEquals((long)1L, (long)root.size());
        Assert.assertEquals((long)1L, (long)mapA.size());
        Assert.assertEquals((long)1L, (long)mapB.size());
        Assert.assertEquals((long)2L, (long)mapC.size());
        Assert.assertSame((Object)colA, (Object)root.metadata("a"));
        Assert.assertSame((Object)colB, (Object)mapA.metadata("b.x"));
        Assert.assertSame((Object)colC, (Object)mapB.metadata("c.y"));
        Assert.assertSame((Object)colD, (Object)mapC.metadata("d"));
        Assert.assertSame((Object)colE, (Object)mapC.metadata("e"));
        Assert.assertEquals((Object)"a", (Object)root.fullName(0));
        Assert.assertEquals((Object)"a.`b.x`", (Object)mapA.fullName(0));
        Assert.assertEquals((Object)"a.`b.x`.`c.y`", (Object)mapB.fullName(0));
        Assert.assertEquals((Object)"a.`b.x`.`c.y`.d", (Object)mapC.fullName(0));
        Assert.assertEquals((Object)"a.`b.x`.`c.y`.e", (Object)mapC.fullName(1));
        Assert.assertEquals((long)1L, (long)colA.schema().getChildren().size());
        Assert.assertEquals((long)1L, (long)colB.schema().getChildren().size());
        Assert.assertEquals((long)2L, (long)colC.schema().getChildren().size());
        Assert.assertTrue((boolean)colA.schema().isEquivalent(fieldA));
    }

    @Test
    public void testUnionSchema() {
        TupleMetadata schema = new SchemaBuilder().addUnion("u").addType(TypeProtos.MinorType.BIGINT).addType(TypeProtos.MinorType.VARCHAR).resumeSchema().buildSchema();
        Assert.assertEquals((long)1L, (long)schema.size());
        ColumnMetadata col = schema.metadata(0);
        Assert.assertTrue((boolean)(col instanceof VariantColumnMetadata));
        Assert.assertEquals((Object)TypeProtos.MinorType.UNION, (Object)col.type());
        Assert.assertEquals((Object)TypeProtos.DataMode.OPTIONAL, (Object)col.mode());
        Assert.assertTrue((boolean)col.isNullable());
        Assert.assertFalse((boolean)col.isArray());
        Assert.assertTrue((boolean)col.isVariant());
        Assert.assertEquals((Object)ColumnMetadata.StructureType.VARIANT, (Object)col.structureType());
        VariantMetadata union = col.variantSchema();
        Assert.assertNotNull((Object)union);
        Assert.assertEquals((long)2L, (long)union.size());
        Assert.assertTrue((boolean)union.hasType(TypeProtos.MinorType.BIGINT));
        Assert.assertTrue((boolean)union.hasType(TypeProtos.MinorType.VARCHAR));
        Assert.assertFalse((boolean)union.hasType(TypeProtos.MinorType.INT));
        Collection types = union.types();
        Assert.assertNotNull((Object)types);
        Assert.assertEquals((long)2L, (long)types.size());
        Assert.assertTrue((boolean)types.contains(TypeProtos.MinorType.BIGINT));
        Assert.assertTrue((boolean)types.contains(TypeProtos.MinorType.VARCHAR));
    }

    @Test
    public void testListSchema() {
        TupleMetadata schema = new SchemaBuilder().addList("list").addType(TypeProtos.MinorType.BIGINT).addType(TypeProtos.MinorType.VARCHAR).resumeSchema().buildSchema();
        Assert.assertEquals((long)1L, (long)schema.size());
        ColumnMetadata col = schema.metadata(0);
        Assert.assertTrue((boolean)(col instanceof VariantColumnMetadata));
        Assert.assertEquals((Object)TypeProtos.MinorType.LIST, (Object)col.type());
        Assert.assertEquals((Object)TypeProtos.DataMode.OPTIONAL, (Object)col.mode());
        Assert.assertTrue((boolean)col.isNullable());
        Assert.assertTrue((boolean)col.isArray());
        Assert.assertTrue((boolean)col.isVariant());
        Assert.assertEquals((Object)ColumnMetadata.StructureType.VARIANT, (Object)col.structureType());
        VariantMetadata union = col.variantSchema();
        Assert.assertNotNull((Object)union);
        Assert.assertEquals((long)2L, (long)union.size());
        Assert.assertTrue((boolean)union.hasType(TypeProtos.MinorType.BIGINT));
        Assert.assertTrue((boolean)union.hasType(TypeProtos.MinorType.VARCHAR));
        Assert.assertFalse((boolean)union.hasType(TypeProtos.MinorType.INT));
        Collection types = union.types();
        Assert.assertNotNull((Object)types);
        Assert.assertEquals((long)2L, (long)types.size());
        Assert.assertTrue((boolean)types.contains(TypeProtos.MinorType.BIGINT));
        Assert.assertTrue((boolean)types.contains(TypeProtos.MinorType.VARCHAR));
    }

    @Test
    public void testNestedSchema() {
        TupleMetadata schema = new SchemaBuilder().addList("list").addType(TypeProtos.MinorType.BIGINT).addType(TypeProtos.MinorType.VARCHAR).addMap().add("a", TypeProtos.MinorType.INT).add("b", TypeProtos.MinorType.VARCHAR).resumeUnion().addList().addType(TypeProtos.MinorType.FLOAT8).addType(TypeProtos.MinorType.DECIMAL18).resumeUnion().resumeSchema().buildSchema();
        Assert.assertEquals((long)1L, (long)schema.size());
        ColumnMetadata col = schema.metadata(0);
        Assert.assertTrue((boolean)col.isVariant());
        VariantMetadata union = col.variantSchema();
        Assert.assertNotNull((Object)union);
        Assert.assertEquals((long)4L, (long)union.size());
        Assert.assertTrue((boolean)union.hasType(TypeProtos.MinorType.MAP));
        Assert.assertTrue((boolean)union.hasType(TypeProtos.MinorType.LIST));
        ColumnMetadata mapCol = union.member(TypeProtos.MinorType.MAP);
        TupleMetadata mapSchema = mapCol.tupleSchema();
        Assert.assertEquals((long)2L, (long)mapSchema.size());
        ColumnMetadata listCol = union.member(TypeProtos.MinorType.LIST);
        VariantMetadata listSchema = listCol.variantSchema();
        Assert.assertEquals((long)2L, (long)listSchema.size());
        Assert.assertTrue((boolean)listSchema.hasType(TypeProtos.MinorType.FLOAT8));
        Assert.assertTrue((boolean)listSchema.hasType(TypeProtos.MinorType.DECIMAL18));
    }

    @Test
    public void testDuplicateType() {
        try {
            new SchemaBuilder().addList("list").addType(TypeProtos.MinorType.BIGINT).addType(TypeProtos.MinorType.BIGINT);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testJsonString() {
        TupleMetadata schema = new SchemaBuilder().add("col_int", TypeProtos.MinorType.INT).buildSchema();
        schema.setProperty("prop", "val");
        String expected = "{\"type\":\"tuple_schema\",\"columns\":[{\"name\":\"col_int\",\"type\":\"INT\",\"mode\":\"REQUIRED\"}],\"properties\":{\"prop\":\"val\"}}";
        Assert.assertEquals((Object)expected, (Object)schema.jsonString());
    }

    @Test
    public void testFromJsonTyped() {
        String jsonString = "{\"type\":\"tuple_schema\",\"columns\":[{\"name\":\"col_int\",\"type\":\"INT\",\"mode\":\"REQUIRED\"}],\"properties\":{\"prop\":\"val\"}}";
        TupleMetadata result = TupleMetadata.of((String)jsonString);
        Assert.assertTrue((boolean)(result instanceof TupleSchema));
        Assert.assertEquals((long)1L, (long)result.size());
        ColumnMetadata column = result.metadata("col_int");
        Assert.assertEquals((Object)TypeProtos.MinorType.INT, (Object)column.type());
        Assert.assertEquals((Object)"val", (Object)result.property("prop"));
    }

    @Test
    public void testFromJsonUntyped() {
        String untyped = "{\"columns\":[{\"name\":\"col_int\",\"type\":\"INT\",\"mode\":\"REQUIRED\"}],\"properties\":{\"prop\":\"val\"}}";
        TupleMetadata result = TupleMetadata.of((String)untyped);
        Assert.assertTrue((boolean)(result instanceof TupleSchema));
        Assert.assertEquals((long)1L, (long)result.size());
        ColumnMetadata column = result.metadata("col_int");
        Assert.assertEquals((Object)TypeProtos.MinorType.INT, (Object)column.type());
        Assert.assertEquals((Object)"val", (Object)result.property("prop"));
    }

    @Test
    public void testNullOrEmptyJsonString() {
        Assert.assertNull((Object)TupleMetadata.of(null));
        Assert.assertNull((Object)TupleMetadata.of((String)""));
        Assert.assertNull((Object)TupleMetadata.of((String)"   "));
    }

    @Test
    public void testCopy() {
        TupleMetadata schema = new SchemaBuilder().add("a", TypeProtos.MinorType.BIGINT).build();
        schema.setIntProperty("int_prop", 1);
        schema.setProperty("string_prop", "A");
        TupleMetadata copy = schema.copy();
        Assert.assertTrue((boolean)schema.isEquivalent(copy));
        Assert.assertEquals((Object)schema.properties(), (Object)copy.properties());
    }

    @Test
    public void testAddNewColumn() {
        TupleMetadata schema = new SchemaBuilder().add("a", TypeProtos.MinorType.BIGINT).build();
        int index = schema.addColumn((ColumnMetadata)MetadataUtils.newScalar((String)"b", (TypeProtos.MajorType)TypeProtos.MajorType.newBuilder().setMinorType(TypeProtos.MinorType.VARCHAR).setMode(TypeProtos.DataMode.OPTIONAL).build()));
        Assert.assertEquals((long)1L, (long)index);
        Assert.assertEquals((long)2L, (long)schema.size());
    }

    @Test
    public void testAddNewProperty() {
        TupleMetadata schema = new SchemaBuilder().add("a", TypeProtos.MinorType.BIGINT).build();
        Assert.assertTrue((boolean)schema.properties().isEmpty());
        schema.setIntProperty("int_prop", 1);
        schema.setProperty("string_prop", "A");
        Assert.assertEquals((long)2L, (long)schema.properties().size());
    }

    @Test
    public void testRemoveProperty() {
        TupleMetadata schema = new SchemaBuilder().add("a", TypeProtos.MinorType.BIGINT).build();
        schema.setIntProperty("int_prop", 1);
        schema.setProperty("string_prop", "A");
        Assert.assertEquals((long)2L, (long)schema.properties().size());
        schema.removeProperty("int_prop");
        Assert.assertEquals((long)1L, (long)schema.properties().size());
        Assert.assertNull((Object)schema.property("int_prop"));
        Assert.assertEquals((Object)"A", (Object)schema.property("string_prop"));
        schema.removeProperty("missing_prop");
        Assert.assertEquals((long)1L, (long)schema.properties().size());
    }

    @Test
    public void testDictColumn() {
        MaterializedField field = SchemaBuilder.columnSchema((String)"d", (TypeProtos.MinorType)TypeProtos.MinorType.DICT, (TypeProtos.DataMode)TypeProtos.DataMode.REQUIRED);
        ColumnMetadata col = MetadataUtils.fromField((MaterializedField)field);
        Assert.assertTrue((boolean)(col instanceof DictColumnMetadata));
        Assert.assertNotNull((Object)col.tupleSchema());
        Assert.assertEquals((long)0L, (long)col.tupleSchema().size());
        Assert.assertSame((Object)col, (Object)col.tupleSchema().parent());
        DictColumnMetadata dictCol = (DictColumnMetadata)col;
        Assert.assertNull((Object)dictCol.parentTuple());
        Assert.assertEquals((Object)ColumnMetadata.StructureType.DICT, (Object)col.structureType());
        Assert.assertFalse((boolean)col.isNullable());
        Assert.assertFalse((boolean)col.isArray());
        Assert.assertFalse((boolean)col.isVariableWidth());
        Assert.assertTrue((boolean)col.isDict());
        Assert.assertFalse((boolean)col.isVariant());
        Assert.assertEquals((long)0L, (long)col.expectedWidth());
        col.setExpectedWidth(10);
        Assert.assertEquals((long)0L, (long)col.expectedWidth());
        Assert.assertEquals((long)1L, (long)col.expectedElementCount());
        col.setExpectedElementCount(2);
        Assert.assertEquals((long)1L, (long)col.expectedElementCount());
    }

    @Test
    public void testRepeatedDictColumn() {
        MaterializedField field = SchemaBuilder.columnSchema((String)"da", (TypeProtos.MinorType)TypeProtos.MinorType.DICT, (TypeProtos.DataMode)TypeProtos.DataMode.REPEATED);
        ColumnMetadata col = MetadataUtils.fromField((MaterializedField)field);
        Assert.assertTrue((boolean)(col instanceof DictColumnMetadata));
        Assert.assertNotNull((Object)col.tupleSchema());
        Assert.assertEquals((long)0L, (long)col.tupleSchema().size());
        Assert.assertFalse((boolean)col.isNullable());
        Assert.assertTrue((boolean)col.isArray());
        Assert.assertFalse((boolean)col.isVariableWidth());
        Assert.assertTrue((boolean)col.isDict());
        Assert.assertFalse((boolean)col.isVariant());
        Assert.assertEquals((long)0L, (long)col.expectedWidth());
        col.setExpectedWidth(10);
        Assert.assertEquals((long)0L, (long)col.expectedWidth());
        Assert.assertEquals((long)10L, (long)col.expectedElementCount());
        col.setExpectedElementCount(2);
        Assert.assertEquals((long)2L, (long)col.expectedElementCount());
    }
}

