
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.drill.exec.vector.complex.impl;

import static org.apache.drill.shaded.guava.com.google.common.base.Preconditions.checkArgument;
import static org.apache.drill.shaded.guava.com.google.common.base.Preconditions.checkState;

import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.ObjectArrays;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;
import org.apache.drill.shaded.guava.com.google.common.collect.ObjectArrays;

import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import io.netty.buffer.*;

import org.apache.commons.lang3.ArrayUtils;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.memory.*;
import org.apache.drill.exec.proto.SchemaDefProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserBitShared.DrillPBError;
import org.apache.drill.exec.proto.UserBitShared.SerializedField;
import org.apache.drill.exec.record.*;
import org.apache.drill.exec.vector.*;
import org.apache.drill.common.exceptions.*;
import org.apache.drill.exec.exception.*;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.common.types.TypeProtos.*;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.vector.complex.*;
import org.apache.drill.exec.vector.complex.reader.*;
import org.apache.drill.exec.vector.complex.impl.*;
import org.apache.drill.exec.vector.complex.writer.*;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.MapWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.DictWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.ListWriter;
import org.apache.drill.exec.util.JsonStringArrayList;
import org.apache.drill.exec.memory.AllocationManager.BufferLedger;

import org.apache.drill.exec.exception.OutOfMemoryException;

import java.util.Arrays;
import java.util.Random;
import java.util.List;
import java.util.Set;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.Instant;
import java.math.BigDecimal;
import java.math.BigInteger;

import org.joda.time.DateTime;
import org.joda.time.Period;

import org.apache.drill.exec.util.Text;

/*
 * This class is generated using freemarker and the RepeatedDictWriter.java template.
 */
public class RepeatedDictWriter extends AbstractFieldWriter implements BaseWriter.DictWriter {

  final RepeatedDictVector container;

  private final SingleDictWriter dictWriter;
  private int currentChildIndex;

  public RepeatedDictWriter(RepeatedDictVector container, FieldWriter parent) {
    super(parent);
    this.container = Preconditions.checkNotNull(container, "Container cannot be null!");
    this.dictWriter = new SingleDictWriter((DictVector) container.getDataVector(), this);
  }

  @Override
  public void allocate() {
    container.allocateNew();
  }

  @Override
  public void clear() {
    container.clear();
  }

  @Override
  public void close() {
    clear();
    container.close();
  }

  @Override
  public int getValueCapacity() {
    return container.getValueCapacity();
  }

  public void setValueCount(int count){
    container.getMutator().setValueCount(count);
  }

  @Override
  public void startList() {
    // make sure that the current vector can support the end position of this list.
    if (container.getValueCapacity() <= idx()) {
      container.getMutator().setValueCount(idx() + 1);
    }

    // update the repeated vector to state that there is current+1 objects.
    final RepeatedDictHolder h = new RepeatedDictHolder();
    container.getAccessor().get(idx(), h);
    if (h.start >= h.end) {
      container.getMutator().startNewValue(idx());
    }
    currentChildIndex = container.getOffsetVector().getAccessor().get(idx());
  }

  @Override
  public void endList() {
    // noop, we initialize state at start rather than end.
  }

  @Override
  public MaterializedField getField() {
    return container.getField();
  }

  @Override
  public void start() {
    currentChildIndex = container.getMutator().add(idx());
    dictWriter.setPosition(currentChildIndex);
    dictWriter.start();
  }

  @Override
  public void end() {
    dictWriter.end();
  }

  @Override
  public void startKeyValuePair() {
    dictWriter.startKeyValuePair();
  }

  @Override
  public void endKeyValuePair() {
    dictWriter.endKeyValuePair();
  }

  @Override
  public ListWriter list(String name) {
    return dictWriter.list(name);
  }

  @Override
  public MapWriter map(String name) {
    return dictWriter.map(name);
  }

  @Override
  public DictWriter dict(String name) {
    return dictWriter.dict(name);
  }


  @Override
  public TinyIntWriter tinyInt(String name) {
    return (FieldWriter) dictWriter.tinyInt(name);
  }

  @Override
  public UInt1Writer uInt1(String name) {
    return (FieldWriter) dictWriter.uInt1(name);
  }

  @Override
  public UInt2Writer uInt2(String name) {
    return (FieldWriter) dictWriter.uInt2(name);
  }

  @Override
  public SmallIntWriter smallInt(String name) {
    return (FieldWriter) dictWriter.smallInt(name);
  }

  @Override
  public IntWriter integer(String name) {
    return (FieldWriter) dictWriter.integer(name);
  }

  @Override
  public UInt4Writer uInt4(String name) {
    return (FieldWriter) dictWriter.uInt4(name);
  }

  @Override
  public Float4Writer float4(String name) {
    return (FieldWriter) dictWriter.float4(name);
  }

  @Override
  public TimeWriter time(String name) {
    return (FieldWriter) dictWriter.time(name);
  }

  @Override
  public IntervalYearWriter intervalYear(String name) {
    return (FieldWriter) dictWriter.intervalYear(name);
  }

  @Override
  public Decimal9Writer decimal9(String name) {
    return (FieldWriter) dictWriter.decimal9(name);
  }

  @Override
  public Decimal9Writer decimal9(String name, int scale, int precision) {
    return (FieldWriter) dictWriter.decimal9(name, scale, precision);
  }

  @Override
  public BigIntWriter bigInt(String name) {
    return (FieldWriter) dictWriter.bigInt(name);
  }

  @Override
  public UInt8Writer uInt8(String name) {
    return (FieldWriter) dictWriter.uInt8(name);
  }

  @Override
  public Float8Writer float8(String name) {
    return (FieldWriter) dictWriter.float8(name);
  }

  @Override
  public DateWriter date(String name) {
    return (FieldWriter) dictWriter.date(name);
  }

  @Override
  public TimeStampWriter timeStamp(String name) {
    return (FieldWriter) dictWriter.timeStamp(name);
  }

  @Override
  public Decimal18Writer decimal18(String name) {
    return (FieldWriter) dictWriter.decimal18(name);
  }

  @Override
  public Decimal18Writer decimal18(String name, int scale, int precision) {
    return (FieldWriter) dictWriter.decimal18(name, scale, precision);
  }

  @Override
  public IntervalDayWriter intervalDay(String name) {
    return (FieldWriter) dictWriter.intervalDay(name);
  }

  @Override
  public IntervalWriter interval(String name) {
    return (FieldWriter) dictWriter.interval(name);
  }

  @Override
  public Decimal28DenseWriter decimal28Dense(String name) {
    return (FieldWriter) dictWriter.decimal28Dense(name);
  }

  @Override
  public Decimal28DenseWriter decimal28Dense(String name, int scale, int precision) {
    return (FieldWriter) dictWriter.decimal28Dense(name, scale, precision);
  }

  @Override
  public Decimal38DenseWriter decimal38Dense(String name) {
    return (FieldWriter) dictWriter.decimal38Dense(name);
  }

  @Override
  public Decimal38DenseWriter decimal38Dense(String name, int scale, int precision) {
    return (FieldWriter) dictWriter.decimal38Dense(name, scale, precision);
  }

  @Override
  public Decimal38SparseWriter decimal38Sparse(String name) {
    return (FieldWriter) dictWriter.decimal38Sparse(name);
  }

  @Override
  public Decimal38SparseWriter decimal38Sparse(String name, int scale, int precision) {
    return (FieldWriter) dictWriter.decimal38Sparse(name, scale, precision);
  }

  @Override
  public Decimal28SparseWriter decimal28Sparse(String name) {
    return (FieldWriter) dictWriter.decimal28Sparse(name);
  }

  @Override
  public Decimal28SparseWriter decimal28Sparse(String name, int scale, int precision) {
    return (FieldWriter) dictWriter.decimal28Sparse(name, scale, precision);
  }

  @Override
  public VarBinaryWriter varBinary(String name) {
    return (FieldWriter) dictWriter.varBinary(name);
  }

  @Override
  public VarCharWriter varChar(String name) {
    return (FieldWriter) dictWriter.varChar(name);
  }

  @Override
  public Var16CharWriter var16Char(String name) {
    return (FieldWriter) dictWriter.var16Char(name);
  }

  @Override
  public VarDecimalWriter varDecimal(String name) {
    return (FieldWriter) dictWriter.varDecimal(name);
  }

  @Override
  public VarDecimalWriter varDecimal(String name, int scale, int precision) {
    return (FieldWriter) dictWriter.varDecimal(name, scale, precision);
  }

  @Override
  public BitWriter bit(String name) {
    return (FieldWriter) dictWriter.bit(name);
  }
}
