/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// This class is generated using Freemarker and the ColumnAccessors.java template.

package org.apache.drill.exec.vector.accessor;

import org.apache.drill.common.types.TypeProtos.MinorType;
import org.apache.drill.exec.vector.accessor.ColumnAccessors.*;
import org.apache.drill.exec.vector.accessor.reader.BaseScalarReader;
import org.apache.drill.exec.vector.accessor.reader.BitColumnReader;
import org.apache.drill.exec.vector.accessor.writer.BaseScalarWriter;
import org.apache.drill.exec.vector.accessor.writer.BitColumnWriter;

public class ColumnAccessorUtils {

  private ColumnAccessorUtils() { }

  public static void defineRequiredReaders(
      Class<? extends BaseScalarReader> readers[]) {
    readers[MinorType.TINYINT.ordinal()] = TinyIntColumnReader.class;
    readers[MinorType.UINT1.ordinal()] = UInt1ColumnReader.class;
    readers[MinorType.UINT2.ordinal()] = UInt2ColumnReader.class;
    readers[MinorType.SMALLINT.ordinal()] = SmallIntColumnReader.class;
    readers[MinorType.INT.ordinal()] = IntColumnReader.class;
    readers[MinorType.UINT4.ordinal()] = UInt4ColumnReader.class;
    readers[MinorType.FLOAT4.ordinal()] = Float4ColumnReader.class;
    readers[MinorType.TIME.ordinal()] = TimeColumnReader.class;
    readers[MinorType.INTERVALYEAR.ordinal()] = IntervalYearColumnReader.class;
    readers[MinorType.DECIMAL9.ordinal()] = Decimal9ColumnReader.class;
    readers[MinorType.BIGINT.ordinal()] = BigIntColumnReader.class;
    readers[MinorType.UINT8.ordinal()] = UInt8ColumnReader.class;
    readers[MinorType.FLOAT8.ordinal()] = Float8ColumnReader.class;
    readers[MinorType.DATE.ordinal()] = DateColumnReader.class;
    readers[MinorType.TIMESTAMP.ordinal()] = TimeStampColumnReader.class;
    readers[MinorType.DECIMAL18.ordinal()] = Decimal18ColumnReader.class;
    readers[MinorType.INTERVALDAY.ordinal()] = IntervalDayColumnReader.class;
    readers[MinorType.INTERVAL.ordinal()] = IntervalColumnReader.class;
    readers[MinorType.DECIMAL38SPARSE.ordinal()] = Decimal38SparseColumnReader.class;
    readers[MinorType.DECIMAL28SPARSE.ordinal()] = Decimal28SparseColumnReader.class;
    readers[MinorType.VARBINARY.ordinal()] = VarBinaryColumnReader.class;
    readers[MinorType.VARCHAR.ordinal()] = VarCharColumnReader.class;
    readers[MinorType.VAR16CHAR.ordinal()] = Var16CharColumnReader.class;
    readers[MinorType.VARDECIMAL.ordinal()] = VarDecimalColumnReader.class;
    readers[MinorType.BIT.ordinal()] = BitColumnReader.class;
  }

  public static void defineRequiredWriters(
      Class<? extends BaseScalarWriter> writers[]) {
    writers[MinorType.TINYINT.ordinal()] = TinyIntColumnWriter.class;
    writers[MinorType.UINT1.ordinal()] = UInt1ColumnWriter.class;
    writers[MinorType.UINT2.ordinal()] = UInt2ColumnWriter.class;
    writers[MinorType.SMALLINT.ordinal()] = SmallIntColumnWriter.class;
    writers[MinorType.INT.ordinal()] = IntColumnWriter.class;
    writers[MinorType.UINT4.ordinal()] = UInt4ColumnWriter.class;
    writers[MinorType.FLOAT4.ordinal()] = Float4ColumnWriter.class;
    writers[MinorType.TIME.ordinal()] = TimeColumnWriter.class;
    writers[MinorType.INTERVALYEAR.ordinal()] = IntervalYearColumnWriter.class;
    writers[MinorType.DECIMAL9.ordinal()] = Decimal9ColumnWriter.class;
    writers[MinorType.BIGINT.ordinal()] = BigIntColumnWriter.class;
    writers[MinorType.UINT8.ordinal()] = UInt8ColumnWriter.class;
    writers[MinorType.FLOAT8.ordinal()] = Float8ColumnWriter.class;
    writers[MinorType.DATE.ordinal()] = DateColumnWriter.class;
    writers[MinorType.TIMESTAMP.ordinal()] = TimeStampColumnWriter.class;
    writers[MinorType.DECIMAL18.ordinal()] = Decimal18ColumnWriter.class;
    writers[MinorType.INTERVALDAY.ordinal()] = IntervalDayColumnWriter.class;
    writers[MinorType.INTERVAL.ordinal()] = IntervalColumnWriter.class;
    writers[MinorType.DECIMAL38SPARSE.ordinal()] = Decimal38SparseColumnWriter.class;
    writers[MinorType.DECIMAL28SPARSE.ordinal()] = Decimal28SparseColumnWriter.class;
    writers[MinorType.VARBINARY.ordinal()] = VarBinaryColumnWriter.class;
    writers[MinorType.VARCHAR.ordinal()] = VarCharColumnWriter.class;
    writers[MinorType.VAR16CHAR.ordinal()] = Var16CharColumnWriter.class;
    writers[MinorType.VARDECIMAL.ordinal()] = VarDecimalColumnWriter.class;
    writers[MinorType.BIT.ordinal()] = BitColumnWriter.class;
  }
}
