
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.drill.exec.expr.holders;

import static org.apache.drill.shaded.guava.com.google.common.base.Preconditions.checkArgument;
import static org.apache.drill.shaded.guava.com.google.common.base.Preconditions.checkState;

import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.shaded.guava.com.google.common.collect.ObjectArrays;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;
import org.apache.drill.shaded.guava.com.google.common.collect.ObjectArrays;

import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import io.netty.buffer.*;

import org.apache.commons.lang3.ArrayUtils;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.memory.*;
import org.apache.drill.exec.proto.SchemaDefProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserBitShared.DrillPBError;
import org.apache.drill.exec.proto.UserBitShared.SerializedField;
import org.apache.drill.exec.record.*;
import org.apache.drill.exec.vector.*;
import org.apache.drill.common.exceptions.*;
import org.apache.drill.exec.exception.*;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.common.types.TypeProtos.*;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.vector.complex.*;
import org.apache.drill.exec.vector.complex.reader.*;
import org.apache.drill.exec.vector.complex.impl.*;
import org.apache.drill.exec.vector.complex.writer.*;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.MapWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.DictWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.ListWriter;
import org.apache.drill.exec.util.JsonStringArrayList;
import org.apache.drill.exec.memory.AllocationManager.BufferLedger;

import org.apache.drill.exec.exception.OutOfMemoryException;

import java.util.Arrays;
import java.util.Random;
import java.util.List;
import java.util.Set;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.Instant;
import java.math.BigDecimal;
import java.math.BigInteger;

import org.joda.time.DateTime;
import org.joda.time.Period;

import org.apache.drill.exec.util.Text;

/*
 * This class is generated using freemarker and the ValueHolders.java template.
 */
/**
 *  Old decimal types are deprecated. Please use {@link VarDecimalHolder} holder instead.
 */
@Deprecated
public final class NullableDecimal28DenseHolder implements ValueHolder {

  @Deprecated
  public static final MajorType TYPE = Types.optional(MinorType.DECIMAL28DENSE);

  public static final int WIDTH = 12;

  public int isSet;
  public int start;
  public DrillBuf buffer;
  public int precision;
  public int scale;
    
  public static final int maxPrecision = 28;
  public static final int nDecimalDigits = 3;
    
  public static int getInteger(int index, int start, DrillBuf buffer) {
    int value = buffer.getInt(start + (index * 4));

    if (index == 0) {
      /* the first byte contains sign bit, return value without it */
      value = (value & 0x0000007F);
    }
    return value;
  }

  public static void setInteger(int index, int value, int start, DrillBuf buffer) {
    buffer.setInt(start + (index * 4), value);
  }
  
  public static void setSign(boolean sign, int start, DrillBuf buffer) {
    // Set MSB to 1 if sign is negative
    if (sign == true) {
      int value = getInteger(0, start, buffer);
      setInteger(0, (value | 0x80000000), start, buffer);
    }
  }
  
  public static boolean getSign(int start, DrillBuf buffer) {
    return ((buffer.getInt(start) & 0x80000000) != 0);
  }

  @Deprecated
  public int hashCode() {
    throw new UnsupportedOperationException();
  }

  /*
   * Reason for deprecation is that ValueHolders are potential scalar replacements
   * and hence we don't want any methods to be invoked on them.
   */
  @Deprecated
  public String toString() {
    throw new UnsupportedOperationException();
  }
}

