
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
// Source code generated using FreeMarker template IntervalAggrFunctions2.java


package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;

@SuppressWarnings("unused")

public class AvgIntervalTypeFunctions {
	static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(AvgFunctions.class);


@FunctionTemplate(name = "avg", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class IntervalDayAvg implements DrillAggFunc{

  @Param IntervalDayHolder in;
  @Workspace BigIntHolder sum;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableIntervalHolder out;

  public void setup() {
  	sum = new BigIntHolder();
    count = new BigIntHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }

  @Override
  public void add() {
    nonNullCount.value = 1;
    sum.value += (long) in.days * (org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis) +
                        in.milliseconds;
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      double millis = sum.value / ((double) count.value);
      out.months = 0;
      out.days = (int) (millis / org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis);
      out.milliseconds = (int) (millis % org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis);
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }

 }


@FunctionTemplate(name = "avg", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableIntervalDayAvg implements DrillAggFunc{

  @Param NullableIntervalDayHolder in;
  @Workspace BigIntHolder sum;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableIntervalHolder out;

  public void setup() {
  	sum = new BigIntHolder();
    count = new BigIntHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    nonNullCount.value = 1;
    sum.value += (long) in.days * (org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis) +
                        in.milliseconds;
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      double millis = sum.value / ((double) count.value);
      out.months = 0;
      out.days = (int) (millis / org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis);
      out.milliseconds = (int) (millis % org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis);
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }

 }


@FunctionTemplate(name = "avg", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class IntervalYearAvg implements DrillAggFunc{

  @Param IntervalYearHolder in;
  @Workspace BigIntHolder sum;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableIntervalHolder out;

  public void setup() {
  	sum = new BigIntHolder();
    count = new BigIntHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }

  @Override
  public void add() {
    nonNullCount.value = 1;
    sum.value += in.value;
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      double millis = sum.value / ((double) count.value);
      out.months = (int) (millis / org.apache.drill.exec.expr.fn.impl.DateUtility.monthsToMillis);
      millis = millis % org.apache.drill.exec.expr.fn.impl.DateUtility.monthsToMillis;
      out.days =(int) (millis / org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis);
      out.milliseconds = (int) (millis % org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis);
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }

 }


@FunctionTemplate(name = "avg", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableIntervalYearAvg implements DrillAggFunc{

  @Param NullableIntervalYearHolder in;
  @Workspace BigIntHolder sum;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableIntervalHolder out;

  public void setup() {
  	sum = new BigIntHolder();
    count = new BigIntHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    nonNullCount.value = 1;
    sum.value += in.value;
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      double millis = sum.value / ((double) count.value);
      out.months = (int) (millis / org.apache.drill.exec.expr.fn.impl.DateUtility.monthsToMillis);
      millis = millis % org.apache.drill.exec.expr.fn.impl.DateUtility.monthsToMillis;
      out.days =(int) (millis / org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis);
      out.milliseconds = (int) (millis % org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis);
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }

 }


@FunctionTemplate(name = "avg", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class IntervalAvg implements DrillAggFunc{

  @Param IntervalHolder in;
  @Workspace BigIntHolder sum;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableIntervalHolder out;

  public void setup() {
  	sum = new BigIntHolder();
    count = new BigIntHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }

  @Override
  public void add() {
    nonNullCount.value = 1;
    sum.value += (long) in.months * org.apache.drill.exec.expr.fn.impl.DateUtility.monthToStandardDays +
                          in.days * (org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis) +
                          in.milliseconds;
    count.value++;

  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      double millis = sum.value / ((double) count.value);
      out.months = (int) (millis / org.apache.drill.exec.expr.fn.impl.DateUtility.monthsToMillis);
      millis = millis % org.apache.drill.exec.expr.fn.impl.DateUtility.monthsToMillis;
      out.days =(int) (millis / org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis);
      out.milliseconds = (int) (millis % org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis);
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }

 }


@FunctionTemplate(name = "avg", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

public static class NullableIntervalAvg implements DrillAggFunc{

  @Param NullableIntervalHolder in;
  @Workspace BigIntHolder sum;
  @Workspace BigIntHolder count;
  @Workspace BigIntHolder nonNullCount;
  @Output NullableIntervalHolder out;

  public void setup() {
  	sum = new BigIntHolder();
    count = new BigIntHolder();
    nonNullCount = new BigIntHolder();
    nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }

  @Override
  public void add() {
	    sout: {
	    if (in.isSet == 0) {
		    // processing nullable input and the value is null, so don't do anything...
		    break sout;
	    }
    nonNullCount.value = 1;
    sum.value += (long) in.months * org.apache.drill.exec.expr.fn.impl.DateUtility.monthToStandardDays +
                          in.days * (org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis) +
                          in.milliseconds;
    count.value++;

    } // end of sout block
  }

  @Override
  public void output() {
    if (nonNullCount.value > 0) {
      out.isSet = 1;
      double millis = sum.value / ((double) count.value);
      out.months = (int) (millis / org.apache.drill.exec.expr.fn.impl.DateUtility.monthsToMillis);
      millis = millis % org.apache.drill.exec.expr.fn.impl.DateUtility.monthsToMillis;
      out.days =(int) (millis / org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis);
      out.milliseconds = (int) (millis % org.apache.drill.exec.expr.fn.impl.DateUtility.daysToStandardMillis);
    } else {
      out.isSet = 0;
    }
  }

  @Override
  public void reset() {
    nonNullCount.value = 0;
    sum.value = 0;
    count.value = 0;
  }

 }

}

