
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.apache.drill.exec.expr.fn.impl.gcast;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.*;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.record.RecordBatch;

public class CastHighFunctions {
  static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(CastHighFunctions.class);


  @SuppressWarnings("unused")
  @FunctionTemplate(name = "casthigh", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
  public static class CastHighInt implements DrillSimpleFunc {

    @Param IntHolder in;
      @Output Float8Holder out;

    public void setup() {}

    public void eval() {
        out.value = (double) in.value;
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "casthigh", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
  public static class CastHighBigInt implements DrillSimpleFunc {

    @Param BigIntHolder in;
      @Output Float8Holder out;

    public void setup() {}

    public void eval() {
        out.value = (double) in.value;
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "casthigh", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
  public static class CastHighFloat4 implements DrillSimpleFunc {

    @Param Float4Holder in;
      @Output Float8Holder out;

    public void setup() {}

    public void eval() {
        out.value = (double) in.value;
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "casthigh", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
  public static class CastHighFloat8 implements DrillSimpleFunc {

    @Param Float8Holder in;
      @Output Float8Holder out;

    public void setup() {}

    public void eval() {
        out.value = (double) in.value;
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "casthigh", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
  public static class CastHighDecimal9 implements DrillSimpleFunc {

    @Param Decimal9Holder in;
      @Output Decimal9Holder out;

    public void setup() {}

    public void eval() {
        out = in;
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "casthigh", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
  public static class CastHighDecimal18 implements DrillSimpleFunc {

    @Param Decimal18Holder in;
      @Output Decimal18Holder out;

    public void setup() {}

    public void eval() {
        out = in;
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "casthigh", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
  public static class CastHighDecimal28Sparse implements DrillSimpleFunc {

    @Param Decimal28SparseHolder in;
      @Output Decimal28SparseHolder out;

    public void setup() {}

    public void eval() {
        out = in;
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "casthigh", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
  public static class CastHighDecimal38Sparse implements DrillSimpleFunc {

    @Param Decimal38SparseHolder in;
      @Output Decimal38SparseHolder out;

    public void setup() {}

    public void eval() {
        out = in;
    }
  }
}

