
/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.apache.drill.exec.expr.fn.impl;

import io.netty.buffer.ByteBuf;

import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import org.joda.time.MutableDateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.DateMidnight;
import org.apache.drill.exec.expr.fn.impl.DateUtility;


public class TimeStampBigIntFunctions {


    @SuppressWarnings("unused")
    @FunctionTemplate(names = {"date_add", "add"}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class TimeStampBigIntAddFunction implements DrillSimpleFunc {
    @Param TimeStampHolder left;
    @Param BigIntHolder right;
    @Workspace org.joda.time.MutableDateTime temp;
    @Output TimeStampHolder out;
        public void setup() {
            temp = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
        }

        public void eval() {

    if (1 == 1) {
        /* Since this will be included in the run time generated code, there might be other logic that follows this
         * if the exception is raised without a condition, we will hit compilation issues while compiling run time code
         * with the error: unreachable code.
         */
        throw new UnsupportedOperationException("Cannot add integer to TIMESTAMP, cast it to specific interval");
    }
        }
    }

    @SuppressWarnings("unused")
    @FunctionTemplate(names = {"date_add", "add"}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class BigIntTimeStampAddFunction implements DrillSimpleFunc {

    @Param BigIntHolder right;
    @Param TimeStampHolder left;
    @Workspace org.joda.time.MutableDateTime temp;
    @Output TimeStampHolder out;
        public void setup() {
            temp = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
        }

        public void eval() {


    if (1 == 1) {
        /* Since this will be included in the run time generated code, there might be other logic that follows this
         * if the exception is raised without a condition, we will hit compilation issues while compiling run time code
         * with the error: unreachable code.
         */
        throw new UnsupportedOperationException("Cannot add integer to TIMESTAMP, cast it to specific interval");
    }
        }
    }

    @SuppressWarnings("unused")
    @FunctionTemplate(names = {"date_sub", "subtract", "date_diff"}, scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.NULL_IF_NULL)
    public static class TimeStampBigIntSubtractFunction implements DrillSimpleFunc {
    @Param TimeStampHolder left;
    @Param BigIntHolder right;
    @Workspace org.joda.time.MutableDateTime temp;
    @Output TimeStampHolder out;

        public void setup() {
            temp = new org.joda.time.MutableDateTime(org.joda.time.DateTimeZone.UTC);
        }

        public void eval() {

    if (1 == 1) {
        /* Since this will be included in the run time generated code, there might be other logic that follows this
         * if the exception is raised without a condition, we will hit compilation issues while compiling run time code
         * with the error: unreachable code.
         */
        throw new UnsupportedOperationException("Cannot add integer to TIMESTAMP, cast it to specific interval");
    }
        }
    }
}

